/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class PolygonScaleHandle
extends AbstractHandle {
    private Point fCurrent;

    public PolygonScaleHandle(PolygonFigure owner) {
        super(owner);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.fCurrent = new Point(x, y);
        UndoActivity activity = (UndoActivity)this.createUndoActivity(view);
        this.setUndoActivity(activity);
        activity.setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        activity.setPolygon(((PolygonFigure)this.owner()).getPolygon());
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.fCurrent = new Point(x, y);
        Polygon polygon = ((UndoActivity)this.getUndoActivity()).getPolygon();
        ((PolygonFigure)this.owner()).scaleRotate(new Point(anchorX, anchorY), polygon, this.fCurrent);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        ((PolygonFigure)this.owner()).smoothPoints();
        if (this.fCurrent.x == anchorX && this.fCurrent.y == anchorY) {
            this.setUndoActivity(null);
        }
        this.fCurrent = null;
    }

    public Point locate() {
        if (this.fCurrent == null) {
            return this.getOrigin();
        }
        return this.fCurrent;
    }

    Point getOrigin() {
        Point outer = ((PolygonFigure)this.owner()).outermostPoint();
        Point ctr = ((PolygonFigure)this.owner()).center();
        double len = Geom.length(outer.x, outer.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point(outer.x - 4, outer.y + 4);
        }
        double u = 8.0 / len;
        if (u > 1.0) {
            return new Point((outer.x * 3 + ctr.x) / 4, (outer.y * 3 + ctr.y) / 4);
        }
        return new Point((int)((double)outer.x * (1.0 - u) + (double)ctr.x * u), (int)((double)outer.y * (1.0 - u) + (double)ctr.y * u));
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        return new UndoActivity(newView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Polygon myPolygon;

        public UndoActivity(DrawingView newView) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetPolygon();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetPolygon();
        }

        protected boolean resetPolygon() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            PolygonFigure figure = (PolygonFigure)fe.nextFigure();
            Polygon backupPolygon = figure.getPolygon();
            figure.willChange();
            figure.setInternalPolygon(this.getPolygon());
            figure.changed();
            this.setPolygon(backupPolygon);
            return true;
        }

        protected void setPolygon(Polygon newPolygon) {
            this.myPolygon = newPolygon;
        }

        public Polygon getPolygon() {
            return this.myPolygon;
        }
    }
}

