/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PolygonTool
extends AbstractTool {
    private PolygonFigure fPolygon;
    private int fLastX;
    private int fLastY;
    private Figure myAddedFigure;

    public PolygonTool(DrawingEditor newDrawingEditor) {
        super(newDrawingEditor);
    }

    public void activate() {
        super.activate();
        this.fPolygon = null;
    }

    public void deactivate() {
        if (this.fPolygon != null) {
            this.fPolygon.smoothPoints();
            if (this.fPolygon.pointCount() < 3 || this.fPolygon.size().width < 4 || this.fPolygon.size().height < 4) {
                this.getActiveView().drawing().remove(this.fPolygon);
                this.setUndoActivity(null);
            }
        }
        this.fPolygon = null;
        super.deactivate();
    }

    private void addPoint(int x, int y) {
        if (this.fPolygon == null) {
            this.fPolygon = new PolygonFigure(x, y);
            this.setAddedFigure(this.view().add(this.fPolygon));
            this.fPolygon.addPoint(x, y);
        } else if (this.fLastX != x || this.fLastY != y) {
            this.fPolygon.addPoint(x, y);
        }
        this.fLastX = x;
        this.fLastY = y;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        x = e.getX();
        y = e.getY();
        if (e.getClickCount() >= 2) {
            if (this.fPolygon != null) {
                this.fPolygon.smoothPoints();
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                this.editor().toolDone();
            }
            this.fPolygon = null;
        } else {
            this.addPoint(e.getX(), e.getY());
        }
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        if (e.getSource() == this.getActiveView() && this.fPolygon != null && this.fPolygon.pointCount() > 1) {
            this.fPolygon.setPointAt(new Point(x, y), this.fPolygon.pointCount() - 1);
            this.getActiveView().checkDamage();
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        x = e.getX();
        y = e.getY();
        this.addPoint(x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }
}

