/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Layoutable;
import CH.ifa.draw.contrib.Layouter;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class SimpleLayouter
implements Layouter {
    private Layoutable myLayoutable;
    private Insets myInsets;
    static final long serialVersionUID = 2928651014089117493L;

    private SimpleLayouter() {
    }

    public SimpleLayouter(Layoutable newLayoutable) {
        this.setLayoutable(newLayoutable);
        this.setInsets(new Insets(0, 0, 0, 0));
    }

    public Layoutable getLayoutable() {
        return this.myLayoutable;
    }

    public void setLayoutable(Layoutable newLayoutable) {
        this.myLayoutable = newLayoutable;
    }

    public void setInsets(Insets newInsets) {
        this.myInsets = newInsets;
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public Layouter create(Layoutable newLayoutable) {
        SimpleLayouter newLayouter = new SimpleLayouter(newLayoutable);
        newLayouter.setInsets((Insets)this.getInsets().clone());
        return newLayouter;
    }

    public Rectangle calculateLayout(Point origin, Point corner) {
        Rectangle maxRect = new Rectangle(origin);
        maxRect.add(corner);
        FigureEnumeration fe = this.getLayoutable().figures();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            maxRect.union(currentFigure.displayBox());
        }
        maxRect.width += this.getInsets().left + this.getInsets().right;
        maxRect.height += this.getInsets().top + this.getInsets().bottom;
        return maxRect;
    }

    public Rectangle layout(Point origin, Point corner) {
        return this.calculateLayout(origin, corner);
    }

    public void read(StorableInput dr) throws IOException {
        this.setLayoutable((Layoutable)dr.readStorable());
        this.setInsets(new Insets(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt()));
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.getLayoutable());
        Insets i = this.getInsets();
        dw.writeInt(i.top);
        dw.writeInt(i.left);
        dw.writeInt(i.bottom);
        dw.writeInt(i.right);
    }
}

