/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.figures.NullConnector;
import CH.ifa.draw.figures.NullFigure;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class SplitConnectionTool
extends ConnectionTool {
    public SplitConnectionTool(DrawingEditor newDrawingEditor, ConnectionFigure newPrototype) {
        super(newDrawingEditor, newPrototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        int ex = e.getX();
        int ey = e.getY();
        if (this.getTargetFigure() == null) {
            this.setTargetFigure(this.findConnectableFigure(ex, ey, this.drawing()));
        } else {
            Figure c;
            if (this.getAddedFigure() == null) {
                this.setConnection(this.createConnection());
                this.setStartConnector(this.findConnector(ex, ey, this.getTargetFigure()));
                this.getConnection().connectStart(this.getStartConnector());
                this.getConnection().startPoint(ex, ey);
                this.setAddedFigure(this.view().add(this.getConnection()));
            }
            if ((c = this.findTarget(ex, ey, this.drawing())) != null) {
                this.setEndConnector(this.findConnector(ex, ex, c));
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().endPoint(ex, ey);
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                this.getConnection().updateConnection();
                this.init();
                this.editor().toolDone();
            } else if (this.getEndConnector() == null) {
                NullFigure tempEndFigure = new NullFigure();
                tempEndFigure.basicDisplayBox(new Point(ex, ey), new Point(ex, ey));
                this.setEndConnector(new NullConnector(tempEndFigure));
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().endPoint(ex, ey);
                this.getConnection().updateConnection();
            } else {
                ((PolyLineFigure)((Object)this.getConnection())).addPoint(ex, ey);
            }
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (e.getClickCount() == 2) {
            this.init();
            this.editor().toolDone();
        }
    }

    public void mouseMove(MouseEvent e, int x, int y) {
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void deactivate() {
        if (this.getConnection() != null) {
            this.view().remove(this.getConnection());
        }
        super.deactivate();
        this.init();
    }

    protected void init() {
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setAddedFigure(null);
        this.setTargetFigure(null);
    }
}

