/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Layoutable;
import CH.ifa.draw.contrib.Layouter;
import CH.ifa.draw.contrib.SimpleLayouter;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Point;
import java.awt.Rectangle;

public class StandardLayouter
extends SimpleLayouter {
    public StandardLayouter() {
        this(null);
    }

    public StandardLayouter(Layoutable newLayoutable) {
        super(newLayoutable);
    }

    public Layouter create(Layoutable newLayoutable) {
        return new StandardLayouter(newLayoutable);
    }

    public Rectangle calculateLayout(Point origin, Point corner) {
        int maxWidth = Math.abs(corner.x - origin.x);
        int maxHeight = 0;
        FigureEnumeration fe = this.getLayoutable().figures();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            Rectangle r = null;
            if (currentFigure instanceof Layoutable) {
                Layouter layoutStrategy = ((Layoutable)currentFigure).getLayouter();
                r = layoutStrategy.calculateLayout(new Point(0, 0), new Point(0, 0));
                r.grow(layoutStrategy.getInsets().left + layoutStrategy.getInsets().right, layoutStrategy.getInsets().top + layoutStrategy.getInsets().bottom);
            } else {
                r = new Rectangle(currentFigure.displayBox().getBounds());
            }
            maxWidth = Math.max(maxWidth, r.width);
            maxHeight += r.height;
        }
        return new Rectangle(origin.x, origin.y, maxWidth, maxHeight);
    }

    public Rectangle layout(Point origin, Point corner) {
        Rectangle r = this.calculateLayout(origin, corner);
        int maxHeight = this.getInsets().top;
        FigureEnumeration fe = this.getLayoutable().figures();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            Point partOrigin = new Point(r.x + this.getInsets().left, r.y + maxHeight);
            Point partCorner = new Point(r.x + this.getInsets().left - this.getInsets().right + r.width, r.y + currentFigure.displayBox().height);
            currentFigure.displayBox(partOrigin, partCorner);
            maxHeight += currentFigure.displayBox().height;
        }
        return new Rectangle(r.x, r.y, r.width, maxHeight + this.getInsets().bottom);
    }
}

