/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.HandleEnumeration;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.standard.HandleEnumerator;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class TextAreaFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    protected boolean fTextIsDirty = true;
    protected transient boolean fSizeIsDirty = true;
    private Rectangle fDisplayBox;
    protected List fParagraphs;
    protected String fText;
    protected Font fFont;
    protected boolean fFontIsDirty = true;
    protected float fFontWidth;
    protected Hashtable attributesMap = new Hashtable();
    protected boolean fIsReadOnly;
    protected Figure fObservedFigure = null;
    protected OffsetLocator fLocator = null;
    static final long serialVersionUID = 4993631445423148845L;

    public TextAreaFigure() {
        this.fParagraphs = CollectionsFactory.current().createList();
        this.fDisplayBox = new Rectangle(0, 0, 30, 15);
        this.fFont = this.createFont();
        this.fText = new String("");
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String newText) {
        if (!newText.equals(this.fText)) {
            this.markTextDirty();
            this.fText = newText;
            this.changed();
        }
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public Font createFont() {
        return new Font((String)this.getAttribute("FontName"), (int)((Integer)this.getAttribute("FontStyle")), (Integer)this.getAttribute("FontSize"));
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.fIsReadOnly = newReadOnly;
    }

    public boolean acceptsTyping() {
        return !this.isReadOnly();
    }

    protected void markTextDirty() {
        this.setTextDirty(true);
    }

    protected void setTextDirty(boolean newTextDirty) {
        this.fTextIsDirty = newTextDirty;
    }

    public boolean isTextDirty() {
        return this.fTextIsDirty;
    }

    protected void markSizeDirty() {
        this.setSizeDirty(true);
    }

    public void setSizeDirty(boolean newSizeIsDirty) {
        this.fSizeIsDirty = newSizeIsDirty;
    }

    public boolean isSizeDirty() {
        return this.fSizeIsDirty;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this.fFont = newFont;
        this.markSizeDirty();
        this.markFontDirty();
        this.attributesMap = new Hashtable(1);
        this.attributesMap.put(TextAttribute.FONT, newFont);
        this.changed();
    }

    public int overlayColumns() {
        return 0;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        Dimension prevSize = this.fDisplayBox.getSize();
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        if (!this.fDisplayBox.getSize().equals(prevSize)) {
            this.markSizeDirty();
        }
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, handles);
        return new HandleEnumerator(handles);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this.fLocator != null) {
            this.fLocator.moveBy(x, y);
        }
        this.changed();
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    public void draw(Graphics g) {
        super.draw(g);
        this.drawText(g, this.displayBox());
    }

    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor((Color)this.getAttribute("FrameColor"));
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected float drawText(Graphics g, Rectangle displayBox) {
        float tabSize;
        Graphics2D g2 = null;
        Shape savedClipArea = null;
        Color savedFontColor = null;
        Rectangle2D clipRect = null;
        RenderingHints savedRenderingHints = null;
        if (g != null) {
            g2 = (Graphics2D)g;
            savedRenderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Font savedFont = g2.getFont();
            savedFontColor = g2.getColor();
            savedClipArea = g2.getClip();
            clipRect = savedClipArea != null ? displayBox.createIntersection((Rectangle2D)savedClipArea) : displayBox;
            g2.setClip(clipRect);
            Color textColor = this.getTextColor();
            if (!ColorMap.isTransparent(textColor)) {
                g2.setColor(textColor);
            }
            g2.setFont(this.getFont());
        }
        FontRenderContext fontRenderCtx = new FontRenderContext(null, false, false);
        this.prepareText();
        float leftMargin = (float)displayBox.x + ((Float)this.getAttribute("LeftMargin")).floatValue();
        float rightMargin = (float)(displayBox.x + displayBox.width) - ((Float)this.getAttribute("RightMargin")).floatValue();
        float topMargin = (float)displayBox.y + ((Float)this.getAttribute("TopMargin")).floatValue();
        float[] tabStops = new float[40];
        float tabPos = tabSize = ((Float)this.getAttribute("TabSize")).floatValue() * this.getFontWidth();
        int tabCnt = 0;
        while (tabCnt < 40) {
            tabStops[tabCnt] = tabPos + leftMargin;
            tabPos += tabSize;
            ++tabCnt;
        }
        float verticalPos = topMargin;
        Iterator paragraphs = this.fParagraphs.iterator();
        while (paragraphs.hasNext()) {
            String paragraphText = (String)paragraphs.next();
            AttributedString attrText = new AttributedString(paragraphText);
            AttributedCharacterIterator paragraphIter = attrText.getIterator();
            int[] tabLocations = new int[paragraphText.length()];
            int tabCount = 0;
            char c = paragraphIter.first();
            while (c != '\uffff') {
                if (c == '\t') {
                    tabLocations[tabCount++] = paragraphIter.getIndex();
                }
                c = paragraphIter.next();
            }
            tabLocations[tabCount] = paragraphIter.getEndIndex() - 1;
            paragraphText = paragraphText.replace('\t', ' ');
            attrText = new AttributedString(paragraphText, this.attributesMap);
            paragraphIter = attrText.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(paragraphIter, fontRenderCtx);
            int currentTab = 0;
            while (measurer.getPosition() < paragraphIter.getEndIndex()) {
                boolean lineContainsText = false;
                boolean lineComplete = false;
                float maxAscent = 0.0f;
                float maxDescent = 0.0f;
                float horizontalPos = leftMargin;
                List layouts = CollectionsFactory.current().createList(1);
                List penPositions = CollectionsFactory.current().createList(1);
                while (!lineComplete) {
                    float wrappingWidth = rightMargin - horizontalPos;
                    TextLayout layout = measurer.nextLayout(wrappingWidth = Math.max(1.0f, wrappingWidth), tabLocations[currentTab] + 1, lineContainsText);
                    if (layout != null) {
                        layouts.add(layout);
                        penPositions.add(new Float(horizontalPos));
                        horizontalPos += layout.getAdvance();
                        maxAscent = Math.max(maxAscent, layout.getAscent());
                        maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                    } else {
                        lineComplete = true;
                    }
                    lineContainsText = true;
                    if (measurer.getPosition() == tabLocations[currentTab] + 1) {
                        ++currentTab;
                    }
                    if (measurer.getPosition() == paragraphIter.getEndIndex()) {
                        lineComplete = true;
                    } else if (horizontalPos >= tabStops[tabStops.length - 1]) {
                        lineComplete = true;
                    }
                    if (lineComplete) continue;
                    int j = 0;
                    while (horizontalPos >= tabStops[j]) {
                        ++j;
                    }
                    horizontalPos = tabStops[j];
                }
                verticalPos += maxAscent;
                Iterator layoutEnum = layouts.iterator();
                Iterator positionEnum = penPositions.iterator();
                while (layoutEnum.hasNext()) {
                    TextLayout nextLayout = (TextLayout)layoutEnum.next();
                    Float nextPosition = (Float)positionEnum.next();
                    if (g2 == null) continue;
                    nextLayout.draw(g2, nextPosition.floatValue(), verticalPos);
                }
                verticalPos += maxDescent;
            }
        }
        if (g2 != null && (double)verticalPos > clipRect.getMaxY() && clipRect.getMaxY() == displayBox.getMaxY()) {
            Stroke savedStroke = g2.getStroke();
            float[] dash = new float[]{2.0f, 4.0f};
            g2.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, dash, 0.0f));
            g2.setColor(Color.red);
            g2.drawLine((int)clipRect.getMinX() + 1, (int)clipRect.getMaxY() - 1, (int)clipRect.getMaxX() - 1, (int)clipRect.getMaxY() - 1);
            g2.setStroke(savedStroke);
        }
        if (g2 != null) {
            if (savedClipArea != null) {
                g2.setClip(savedClipArea);
            }
            g2.setColor(savedFontColor);
            g2.setRenderingHints(savedRenderingHints);
        }
        return verticalPos;
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareText() {
        String paragraphText;
        if (!this.isTextDirty()) {
            return;
        }
        this.fParagraphs = CollectionsFactory.current().createList();
        Point pos = new Point(-1, -1);
        while ((paragraphText = this.getNextParagraph(this.fText, pos)) != null) {
            void var1_2;
            if (var1_2.length() == 0) {
                paragraphText = " ";
            }
            this.fParagraphs.add(paragraphText);
        }
        this.setTextDirty(false);
    }

    protected String getNextParagraph(String text, Point pos) {
        int start = pos.y + 1;
        if (start >= text.length()) {
            return null;
        }
        pos.x = start;
        int end = text.indexOf(10, start);
        if (end == -1) {
            end = text.length();
        }
        pos.y = end;
        if (text.charAt(end - 1) == '\r') {
            return text.substring(start, end - 1);
        }
        return text.substring(start, end);
    }

    public Object getAttribute(String name) {
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        Font font = this.getFont();
        if (name.equals("FontSize")) {
            Integer s = (Integer)value;
            this.setFont(new Font(font.getName(), font.getStyle(), s));
            super.setAttribute(name, value);
        } else if (name.equals("FontStyle")) {
            Integer s = (Integer)value;
            int style = font.getStyle();
            style = s == 0 ? 0 : (style ^= s.intValue());
            this.setFont(new Font(font.getName(), style, font.getSize()));
            super.setAttribute(name, (Object)new Integer(style));
        } else if (name.equals("FontName")) {
            String n = (String)value;
            this.setFont(new Font(n, font.getStyle(), font.getSize()));
            super.setAttribute(name, value);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeString(this.fText);
        dw.writeBoolean(this.fIsReadOnly);
        dw.writeStorable(this.fObservedFigure);
        dw.writeStorable(this.fLocator);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.markSizeDirty();
        this.markTextDirty();
        this.markFontDirty();
        this.fDisplayBox.x = dr.readInt();
        this.fDisplayBox.y = dr.readInt();
        this.fDisplayBox.width = dr.readInt();
        this.fDisplayBox.height = dr.readInt();
        this.fText = dr.readString();
        this.fIsReadOnly = dr.readBoolean();
        this.fObservedFigure = (Figure)dr.readStorable();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.fLocator = (OffsetLocator)dr.readStorable();
        this.setFont(this.createFont());
    }

    protected void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.markSizeDirty();
        this.markTextDirty();
        this.markFontDirty();
    }

    public void connect(Figure figure) {
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
        this.fObservedFigure = figure;
        this.fLocator = new OffsetLocator(figure.connectedTextLocator(this));
        this.fObservedFigure.addFigureChangeListener(this);
        this.updateLocation();
    }

    public void disconnect(Figure disconnectFigure) {
        if (disconnectFigure != null) {
            disconnectFigure.removeFigureChangeListener(this);
        }
        this.fLocator = null;
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureChanged(FigureChangeEvent e) {
        this.updateLocation();
    }

    protected void updateLocation() {
        if (this.fLocator != null) {
            Point p = this.fLocator.locate(this.fObservedFigure);
            p.x -= this.size().width / 2 + this.fDisplayBox.x;
            p.y -= this.size().height / 2 + this.fDisplayBox.y;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    public void figureRemoved(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    protected float getFontWidth() {
        this.updateFontInfo();
        return this.fFontWidth;
    }

    protected void updateFontInfo() {
        if (!this.isFontDirty()) {
            return;
        }
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        this.fFontWidth = metrics.charWidth('W');
        this.setFontDirty(false);
    }

    public Color getTextColor() {
        return (Color)this.getAttribute("TextColor");
    }

    public boolean isEmpty() {
        return this.fText.length() == 0;
    }

    protected void markFontDirty() {
        this.setFontDirty(true);
    }

    public boolean isFontDirty() {
        return this.fFontIsDirty;
    }

    public void setFontDirty(boolean newFontIsDirty) {
        this.fFontIsDirty = newFontIsDirty;
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    static {
        AttributeFigure.initDefaultAttribute("LeftMargin", new Float(5.0f));
        AttributeFigure.initDefaultAttribute("RightMargin", new Float(5.0f));
        AttributeFigure.initDefaultAttribute("TopMargin", new Float(5.0f));
        AttributeFigure.initDefaultAttribute("TabSize", new Float(8.0f));
    }
}

