/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.FloatingTextArea;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextAreaTool
extends CreationTool {
    protected FloatingTextArea fTextField;
    protected TextHolder fTypingTarget;
    protected Figure fEditedFigure;

    public TextAreaTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        TextHolder textHolder = null;
        if (pressedFigure != null) {
            textHolder = pressedFigure.getTextHolder();
        }
        if (textHolder != null && textHolder.acceptsTyping()) {
            this.beginEdit(textHolder, pressedFigure);
            return;
        }
        if (this.getTypingTarget() != null) {
            this.endEdit();
            if (this.getCreatedFigure() != null && this.getCreatedFigure().isEmpty()) {
                this.drawing().remove(this.getAddedFigure());
                this.setUndoActivity(null);
            }
            this.setTypingTarget(null);
            this.setCreatedFigure(null);
            this.setEditedFigure(null);
            this.setAddedFigure(null);
            this.editor().toolDone();
        } else {
            super.mouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.getCreatedFigure() == null) {
            return;
        }
        super.mouseDrag(e, x, y);
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.getCreatedFigure() == null) {
            return;
        }
        this.view().checkDamage();
        TextHolder textHolder = (TextHolder)((Object)this.getCreatedFigure());
        if (textHolder.acceptsTyping()) {
            this.beginEdit(textHolder, this.getCreatedFigure());
        } else {
            this.editor().toolDone();
        }
    }

    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    public void activate() {
        super.activate();
        this.getActiveView().clearSelection();
    }

    public boolean isActivated() {
        return this.getTypingTarget() != null;
    }

    protected void beginEdit(TextHolder figure, Figure selectedFigure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextArea();
        }
        if (figure != this.getTypingTarget() && this.getTypingTarget() != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), this.getFont(figure));
        this.fTextField.setBounds(this.fieldBounds(figure), figure.getText());
        this.setTypingTarget(figure);
        this.setEditedFigure(selectedFigure);
        this.setUndoActivity(this.createUndoActivity());
    }

    protected Font getFont(TextHolder figure) {
        return figure.getFont();
    }

    protected void endEdit() {
        if (this.getTypingTarget() != null) {
            if (this.fTextField.getText().length() > 0) {
                this.getTypingTarget().setText(this.fTextField.getText());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getEditedFigure()));
                ((UndoActivity)this.getUndoActivity()).setBackupText(this.getTypingTarget().getText());
            } else {
                this.drawing().orphan(this.getAddedFigure());
            }
            this.fTextField.endOverlay();
            this.fTextField = null;
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        return figure.textDisplayBox();
    }

    protected void setTypingTarget(TextHolder newTypingTarget) {
        this.fTypingTarget = newTypingTarget;
    }

    protected Figure getEditedFigure() {
        return this.fEditedFigure;
    }

    protected void setEditedFigure(Figure figure) {
        this.fEditedFigure = figure;
    }

    protected TextHolder getTypingTarget() {
        return this.fTypingTarget;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private String myOriginalText;
        private String myBackupText;

        public UndoActivity(DrawingView newDrawingView, String newOriginalText) {
            super(newDrawingView);
            this.setOriginalText(newOriginalText);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    this.getDrawingView().drawing().orphan(fe.nextFigure());
                }
            } else if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    this.getDrawingView().add(fe.nextFigure());
                }
                this.setText(this.getOriginalText());
            } else {
                this.setText(this.getOriginalText());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    this.getDrawingView().drawing().orphan(fe.nextFigure());
                }
            } else if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    this.getDrawingView().drawing().add(fe.nextFigure());
                    this.setText(this.getBackupText());
                }
            } else {
                this.setText(this.getBackupText());
            }
            return true;
        }

        protected boolean isValidText(String toBeChecked) {
            return toBeChecked != null && toBeChecked.length() > 0;
        }

        protected void setText(String newText) {
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                currentFigure.getTextHolder().setText(newText);
            }
        }

        public void setBackupText(String newBackupText) {
            this.myBackupText = newBackupText;
        }

        public String getBackupText() {
            return this.myBackupText;
        }

        public void setOriginalText(String newOriginalText) {
            this.myOriginalText = newOriginalText;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }
    }
}

