/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.dnd;

import CH.ifa.draw.contrib.dnd.DNDFigures;
import CH.ifa.draw.contrib.dnd.DNDFiguresTransferable;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.JComponent;

public abstract class DNDHelper
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    public static DataFlavor ASCIIFlavor = new DataFlavor("text/plain; charset=ascii", "ASCII text");
    protected DragGestureRecognizer dgr;
    protected DropTarget dt;
    protected Boolean autoscrollState;
    private int fLastX = 0;
    private int fLastY = 0;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$CH$ifa$draw$framework$DrawingView;
    static /* synthetic */ Class class$javax$swing$JComponent;

    protected abstract DrawingView view();

    protected static Object ProcessReceivedData(DataFlavor flavor, Transferable transferable) {
        if (transferable == null) {
            return null;
        }
        try {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                String str = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return str;
            }
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                List aList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File[] fList = new File[aList.size()];
                aList.toArray(fList);
                return fList;
            }
            if (flavor.equals(ASCIIFlavor)) {
                int length;
                byte[] bytes;
                String txt = null;
                InputStream is = (InputStream)transferable.getTransferData(ASCIIFlavor);
                int n = is.read(bytes = new byte[length = is.available()]);
                if (n > 0) {
                    txt = new String(bytes, 0, n);
                }
                return txt;
            }
            if (flavor.equals(DNDFiguresTransferable.DNDFiguresFlavor)) {
                DNDFigures ff = (DNDFigures)transferable.getTransferData(DNDFiguresTransferable.DNDFiguresFlavor);
                return ff;
            }
            return null;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return null;
        }
        catch (UnsupportedFlavorException ufe) {
            System.err.println(ufe);
            return null;
        }
        catch (ClassCastException cce) {
            System.err.println(cce);
            return null;
        }
    }

    public boolean setDropTargetActive(boolean state) {
        if (state) {
            return this.createDropTarget();
        }
        this.destroyDropTarget();
        return false;
    }

    public boolean setDragSourceActive(boolean state) {
        if (state) {
            return this.createDragGestureRecognizer();
        }
        this.destroyDragGestreRecognizer();
        return false;
    }

    protected boolean createDropTarget() {
        if ((class$java$awt$Component == null ? (class$java$awt$Component = DNDHelper.class$("java.awt.Component")) : class$java$awt$Component).isInstance(this.view())) {
            try {
                this.dt = new DropTarget((Component)((Object)this.view()), 3, this);
                System.out.println("" + this.view() + " Initialized to DND.");
                return true;
            }
            catch (NullPointerException npe) {
                System.err.println("View Failed to initialize to DND.");
                System.err.println("Container likely did not have peer before the DropTarget was added");
                System.err.println(npe);
                npe.printStackTrace();
            }
        }
        return false;
    }

    protected void destroyDropTarget() {
        if (this.dt != null) {
            this.dt.setComponent(null);
            this.dt.removeDropTargetListener(this);
            this.dt = null;
        }
    }

    protected boolean createDragGestureRecognizer() {
        if ((class$java$awt$Component == null ? (class$java$awt$Component = DNDHelper.class$("java.awt.Component")) : class$java$awt$Component).isInstance(this.view())) {
            Component c = (Component)((Object)this.view());
            this.dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(c, 3, this);
            return true;
        }
        return false;
    }

    protected void destroyDragGestreRecognizer() {
        System.out.println("Destroying DGR");
        if (this.dgr != null) {
            this.dgr.removeDragGestureListener(this);
            this.dgr.setComponent(null);
            this.dgr = null;
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Component c;
        if ((class$CH$ifa$draw$framework$DrawingView == null ? (class$CH$ifa$draw$framework$DrawingView = DNDHelper.class$("CH.ifa.draw.framework.DrawingView")) : class$CH$ifa$draw$framework$DrawingView).isInstance(c = dge.getComponent())) {
            boolean found = false;
            DrawingView dv = (DrawingView)((Object)c);
            FigureEnumeration selectedElements = dv.selection();
            if (!selectedElements.hasNextFigure()) {
                return;
            }
            Point p = dge.getDragOrigin();
            while (selectedElements.hasNextFigure()) {
                Figure f = selectedElements.nextFigure();
                if (!f.containsPoint(p.x, p.y)) continue;
                found = true;
                break;
            }
            if (found) {
                DNDFigures dndff = new DNDFigures(dv.selection(), p);
                DNDFiguresTransferable trans = new DNDFiguresTransferable(dndff);
                if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = DNDHelper.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(c)) {
                    ((JComponent)c).setAutoscrolls(false);
                }
                dge.getDragSource().startDrag(dge, null, trans, this);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.supportDropTargetDragEvent(dtde);
        if (this.fLastX == 0) {
            this.fLastX = dtde.getLocation().x;
        }
        if (this.fLastY == 0) {
            this.fLastY = dtde.getLocation().y;
        }
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.supportDropTargetDragEvent(dtde)) {
            int x = dtde.getLocation().x;
            int y = dtde.getLocation().y;
            if (Math.abs(x - this.fLastX) > 0 || Math.abs(y - this.fLastY) > 0) {
                this.fLastX = x;
                this.fLastY = y;
            }
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        System.out.println("DropTargetDropEvent-drop");
        if (dtde.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            System.out.println("DNDFiguresFlavor");
            if ((dtde.getDropAction() & 3) != 0) {
                System.out.println("copy or move");
                if (!dtde.isLocalTransfer()) {
                    System.err.println("Intra-JVM Transfers not implemented for figures yet.");
                    return;
                }
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    DNDFigures ff = (DNDFigures)DNDHelper.ProcessReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dtde.getTransferable());
                    FigureEnumeration fe = ff.getFigures();
                    Point theO = ff.getOrigin();
                    this.view().clearSelection();
                    Point newP = dtde.getLocation();
                    int dx = newP.x - theO.x;
                    int dy = newP.y - theO.y;
                    while (fe.hasNextFigure()) {
                        Figure f = fe.nextFigure();
                        f.moveBy(dx, dy);
                        this.view().add(f);
                        if (dtde.getDropAction() == 2) {
                            this.view().addToSelection(f);
                        }
                        System.out.println("added to view");
                    }
                    this.view().checkDamage();
                    dtde.getDropTargetContext().dropComplete(true);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrop(dtde.getDropAction());
            Object o = DNDHelper.ProcessReceivedData(DataFlavor.stringFlavor, dtde.getTransferable());
            if (o != null) {
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(ASCIIFlavor)) {
            dtde.acceptDrop(1);
            Object o = DNDHelper.ProcessReceivedData(ASCIIFlavor, dtde.getTransferable());
            if (o != null) {
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrop(1);
            File[] fList = (File[])DNDHelper.ProcessReceivedData(DataFlavor.javaFileListFlavor, dtde.getTransferable());
            if (fList != null) {
                int x = 0;
                while (x < fList.length) {
                    System.out.println(fList[x].getAbsolutePath());
                    ++x;
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        }
        this.fLastX = 0;
        this.fLastY = 0;
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.supportDropTargetDragEvent(dtde);
    }

    protected boolean supportDropTargetDragEvent(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            if (dtde.getDropAction() == 1) {
                dtde.acceptDrag(1);
                return true;
            }
            if (dtde.getDropAction() == 2) {
                dtde.acceptDrag(2);
                return true;
            }
            dtde.rejectDrag();
            return false;
        }
        if (dtde.isDataFlavorSupported(ASCIIFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(dtde.getDropAction());
            return true;
        }
        dtde.rejectDrag();
        return false;
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        Component c;
        DrawingView view = (DrawingView)((Object)dsde.getDragSourceContext().getComponent());
        System.out.println("DragSourceDropEvent-dragDropEnd");
        if (dsde.getDropSuccess()) {
            if (dsde.getDropAction() == 2) {
                DNDFigures df = (DNDFigures)DNDHelper.ProcessReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dsde.getDragSourceContext().getTransferable());
                FigureEnumeration fe = df.getFigures();
                if (fe != null) {
                    while (fe.hasNextFigure()) {
                        Figure f = fe.nextFigure();
                        view.remove(f);
                        System.out.println("removing " + f);
                    }
                    view.clearSelection();
                    view.checkDamage();
                }
            } else if (dsde.getDropAction() == 1) {
                // empty if block
            }
        }
        if (this.autoscrollState != null && (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = DNDHelper.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(c = dsde.getDragSourceContext().getComponent())) {
            JComponent jc = (JComponent)c;
            jc.setAutoscrolls(this.autoscrollState);
            this.autoscrollState = null;
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        Component c;
        if (this.autoscrollState == null && (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = DNDHelper.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isInstance(c = dsde.getDragSourceContext().getComponent())) {
            JComponent jc = (JComponent)c;
            this.autoscrollState = new Boolean(jc.getAutoscrolls());
            jc.setAutoscrolls(false);
        }
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

