/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.dnd;

import CH.ifa.draw.contrib.dnd.DNDInterface;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.SelectAreaTracker;
import CH.ifa.draw.util.CollectionsFactory;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;

public class DragNDropTool
extends AbstractTool {
    private Tool fChild;
    private List comps = CollectionsFactory.current().createList();
    static /* synthetic */ Class class$CH$ifa$draw$contrib$dnd$DNDInterface;
    static /* synthetic */ Class class$CH$ifa$draw$standard$LocatorHandle;
    static /* synthetic */ Class class$CH$ifa$draw$standard$RelativeLocator;

    public DragNDropTool(DrawingEditor editor) {
        super(editor);
    }

    public void viewCreated(DrawingView view) {
        super.viewCreated(view);
        if ((class$CH$ifa$draw$contrib$dnd$DNDInterface == null ? (class$CH$ifa$draw$contrib$dnd$DNDInterface = DragNDropTool.class$("CH.ifa.draw.contrib.dnd.DNDInterface")) : class$CH$ifa$draw$contrib$dnd$DNDInterface).isInstance(view)) {
            DNDInterface dndi = (DNDInterface)((Object)view);
            dndi.setDropTargetActive(true);
            dndi.setDragSourceActive(false);
            this.comps.add(dndi);
        }
    }

    public void viewDestroying(DrawingView view) {
        if ((class$CH$ifa$draw$contrib$dnd$DNDInterface == null ? (class$CH$ifa$draw$contrib$dnd$DNDInterface = DragNDropTool.class$("CH.ifa.draw.contrib.dnd.DNDInterface")) : class$CH$ifa$draw$contrib$dnd$DNDInterface).isInstance(view)) {
            DNDInterface dndi = (DNDInterface)((Object)view);
            dndi.setDropTargetActive(false);
            dndi.setDragSourceActive(false);
            this.comps.remove(dndi);
        }
        super.viewDestroying(view);
    }

    public void activate() {
        super.activate();
        System.out.println("DNDTool Activation");
        this.setDragSourceActive(true);
    }

    public void deactivate() {
        System.out.println("DNDTool deactivation.");
        this.setDragSourceActive(false);
        super.deactivate();
    }

    private void setDragSourceActive(boolean newState) {
        Iterator it = this.comps.iterator();
        while (it.hasNext()) {
            DNDInterface dndi = (DNDInterface)it.next();
            dndi.setDragSourceActive(newState);
        }
    }

    public static void setCursor(int x, int y, DrawingView view) {
        if (view == null) {
            return;
        }
        Handle handle = view.findHandle(x, y);
        Figure figure = view.drawing().findFigure(x, y);
        if (handle != null) {
            LocatorHandle lh;
            Locator loc;
            if ((class$CH$ifa$draw$standard$LocatorHandle == null ? (class$CH$ifa$draw$standard$LocatorHandle = DragNDropTool.class$("CH.ifa.draw.standard.LocatorHandle")) : class$CH$ifa$draw$standard$LocatorHandle).isInstance(handle) && (class$CH$ifa$draw$standard$RelativeLocator == null ? (class$CH$ifa$draw$standard$RelativeLocator = DragNDropTool.class$("CH.ifa.draw.standard.RelativeLocator")) : class$CH$ifa$draw$standard$RelativeLocator).isInstance(loc = (lh = (LocatorHandle)handle).getLocator())) {
                RelativeLocator rl = (RelativeLocator)loc;
                if (rl.equals(RelativeLocator.north())) {
                    view.setCursor(new Cursor(8));
                } else if (rl.equals(RelativeLocator.northEast())) {
                    view.setCursor(new Cursor(7));
                } else if (rl.equals(RelativeLocator.east())) {
                    view.setCursor(new Cursor(11));
                } else if (rl.equals(RelativeLocator.southEast())) {
                    view.setCursor(new Cursor(5));
                } else if (rl.equals(RelativeLocator.south())) {
                    view.setCursor(new Cursor(9));
                } else if (rl.equals(RelativeLocator.southWest())) {
                    view.setCursor(new Cursor(4));
                } else if (rl.equals(RelativeLocator.west())) {
                    view.setCursor(new Cursor(10));
                } else if (rl.equals(RelativeLocator.northWest())) {
                    view.setCursor(new Cursor(6));
                }
            }
        } else if (figure != null) {
            view.setCursor(new Cursor(13));
        } else {
            view.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
        if (evt.getSource() == this.getActiveView()) {
            DragNDropTool.setCursor(evt.getX(), evt.getY(), this.getActiveView());
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseUp(e, x, y);
        }
        this.fChild = null;
        this.view().unfreezeView();
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        if (this.fChild != null) {
            return;
        }
        this.view().freezeView();
        Handle handle = this.view().findHandle(e.getX(), e.getY());
        if (handle != null) {
            this.fChild = this.createHandleTracker(handle);
        } else {
            Figure figure = this.drawing().findFigure(e.getX(), e.getY());
            if (figure != null) {
                this.fChild = null;
                if (e.isShiftDown()) {
                    this.view().toggleSelection(figure);
                } else if (!this.view().isFigureSelected(figure)) {
                    this.view().clearSelection();
                    this.view().addToSelection(figure);
                }
            } else {
                if (!e.isShiftDown()) {
                    this.view().clearSelection();
                }
                this.fChild = this.createAreaTracker();
            }
        }
        if (this.fChild != null) {
            this.fChild.mouseDown(e, x, y);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(e, x, y);
        }
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker(this.editor());
    }

    protected Tool createDragTracker(DrawingEditor editor, Figure f) {
        return new DragTracker(editor, f);
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(this.editor(), handle);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

