/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.ContentProducerContext;
import CH.ifa.draw.contrib.html.FigureDataContentProducer;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;

public class ColorContentProducer
extends FigureDataContentProducer
implements Serializable {
    Color fColor = null;

    public ColorContentProducer() {
    }

    public ColorContentProducer(Color color) {
        this.fColor = color;
    }

    public Object getContent(ContentProducerContext context, String ctxAttrName, Object ctxAttrValue) {
        Color color = this.fColor != null ? this.fColor : (Color)ctxAttrValue;
        String colorCode = Integer.toHexString(color.getRGB());
        return "0x" + colorCode.substring(colorCode.length() - 6);
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.fColor != null);
        if (this.fColor != null) {
            dw.writeInt(this.fColor.getRGB());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        boolean hasColor = dr.readBoolean();
        this.fColor = hasColor ? new Color(dr.readInt()) : null;
    }
}

