/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.ContentProducer;
import CH.ifa.draw.contrib.html.URLContentProducer;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ContentProducerRegistry
implements Serializable,
Storable {
    protected Hashtable fContentProducers = new Hashtable();
    protected transient ContentProducerRegistry fParent = null;
    protected static ContentProducerRegistry fDefaultRegistry = new ContentProducerRegistry(null);
    static /* synthetic */ Class class$java$net$URL;

    public ContentProducerRegistry() {
        this.fParent = fDefaultRegistry;
    }

    public ContentProducerRegistry(ContentProducerRegistry parent) {
        this.fParent = parent;
    }

    public void setAutonomous() {
        this.fParent = null;
    }

    public boolean isAutonomous() {
        return this.fParent == null;
    }

    public void setParent(ContentProducerRegistry newParent) {
        this.fParent = newParent;
    }

    public ContentProducerRegistry getParent() {
        return this.fParent;
    }

    public static ContentProducer registerDefaultContentProducer(Class targetClass, ContentProducer producer) {
        return fDefaultRegistry.registerContentProducer(targetClass, producer);
    }

    public static void unregisterDefaultContentProducer(Class targetClass, ContentProducer producer) {
        fDefaultRegistry.unregisterContentProducer(targetClass, producer);
    }

    public static ContentProducer getDefaultContentProducer(Class targetClass) {
        return fDefaultRegistry.getContentProducer(targetClass);
    }

    public static ContentProducer getExactDefaultContentProducer(Class targetClass) {
        return fDefaultRegistry.getExactContentProducer(targetClass);
    }

    public ContentProducer registerContentProducer(Class targetClass, ContentProducer producer) {
        ContentProducer previousProducer = this.getContentProducer(targetClass);
        this.fContentProducers.put(targetClass, producer);
        return previousProducer;
    }

    public void unregisterContentProducer(Class targetClass, ContentProducer producer) {
        ContentProducer currentProducer = this.getContentProducer(targetClass);
        if (currentProducer == producer) {
            this.fContentProducers.remove(targetClass);
        }
    }

    public ContentProducer getContentProducer(Class targetClass) {
        ContentProducer producer = this.getExactContentProducer(targetClass);
        if (producer != null) {
            return producer;
        }
        return this.getSuperClassContentProducer(targetClass, null);
    }

    public ContentProducer getExactContentProducer(Class targetClass) {
        ContentProducer producer = (ContentProducer)this.fContentProducers.get(targetClass);
        if (producer != null) {
            return producer;
        }
        if (!this.isAutonomous()) {
            return this.getParent().getExactContentProducer(targetClass);
        }
        return null;
    }

    protected ContentProducer getSuperClassContentProducer(Class targetClass, Class closestClass) {
        ContentProducer parentProducer;
        ContentProducer closestProducer = null;
        Iterator iter = this.fContentProducers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Class entryClass = (Class)entry.getKey();
            if (!entryClass.isAssignableFrom(targetClass) || closestClass == null || !closestClass.isAssignableFrom(entryClass)) continue;
            closestClass = entryClass;
            closestProducer = (ContentProducer)entry.getValue();
        }
        if (!this.isAutonomous() && (parentProducer = this.getParent().getSuperClassContentProducer(targetClass, closestClass)) != null) {
            closestProducer = parentProducer;
        }
        return closestProducer;
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fContentProducers.size());
        Iterator iter = this.fContentProducers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry producerEntry = iter.next();
            dw.writeString(((Class)producerEntry.getKey()).getName());
            dw.writeStorable((Storable)producerEntry.getKey());
        }
    }

    public void read(StorableInput dr) throws IOException {
        int prodCount = dr.readInt();
        int cnt = 0;
        while (cnt < prodCount) {
            String prodClass = dr.readString();
            ContentProducer producer = (ContentProducer)dr.readStorable();
            try {
                this.registerContentProducer(Class.forName(prodClass), producer);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
            ++cnt;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fDefaultRegistry.registerContentProducer(class$java$net$URL == null ? (class$java$net$URL = ContentProducerRegistry.class$("java.net.URL")) : class$java$net$URL, new URLContentProducer());
    }
}

