/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.DisposableResourceHolder;
import CH.ifa.draw.contrib.html.DisposableResourceManager;
import CH.ifa.draw.contrib.html.ETSLADisposalStrategy;
import CH.ifa.draw.contrib.html.ResourceDisposabilityStrategy;
import CH.ifa.draw.contrib.html.ResourceManagerNotSetException;
import CH.ifa.draw.contrib.html.StandardDisposableResourceHolder;
import CH.ifa.draw.contrib.html.StandardDisposableResourceManager;

public abstract class DisposableResourceManagerFactory {
    public static long DEFAULT_DISPOSAL_PERIODICITY = 60000L;
    protected static DisposableResourceManager currentManager = null;
    protected static ResourceDisposabilityStrategy currentStrategy = null;
    protected static DisposableResourceHolder holderPrototype = null;

    public static DisposableResourceManager getManager() {
        return currentManager;
    }

    public static void setStrategy(ResourceDisposabilityStrategy strategy) {
        currentStrategy = strategy;
    }

    public static DisposableResourceHolder createStandardHolder(Object resource) {
        DisposableResourceManagerFactory.initManager();
        DisposableResourceHolder holder = (DisposableResourceHolder)holderPrototype.clone();
        holder.setResource(resource);
        DisposableResourceManagerFactory.getManager().registerResource(holder);
        return holder;
    }

    protected static void initManager() {
        block5: {
            if (currentManager != null) break block5;
            if (holderPrototype == null) {
                holderPrototype = new StandardDisposableResourceHolder();
            }
            if (currentStrategy == null) {
                currentStrategy = new ETSLADisposalStrategy(DEFAULT_DISPOSAL_PERIODICITY);
            }
            if (currentManager == null) {
                currentManager = new StandardDisposableResourceManager(currentStrategy);
            }
            try {
                currentManager.startDisposing();
            }
            catch (ResourceManagerNotSetException ex) {}
        }
    }
}

