/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.DisposableResourceHolder;
import CH.ifa.draw.contrib.html.DisposableResourceManager;
import CH.ifa.draw.contrib.html.DisposalThread;
import CH.ifa.draw.contrib.html.ResourceDisposabilityStrategy;
import CH.ifa.draw.contrib.html.ResourceManagerNotSetException;
import java.util.Iterator;

public class ETSLADisposalStrategy
implements ResourceDisposabilityStrategy {
    protected DisposableResourceManager manager;
    protected long gcPeriodicity = 60000L;
    protected DisposalThread disposalThread = null;
    protected boolean disposingActive = false;

    public ETSLADisposalStrategy() {
    }

    public ETSLADisposalStrategy(long periodicity) {
        this.gcPeriodicity = periodicity;
        this.initDisposalThread();
    }

    public ETSLADisposalStrategy(DisposableResourceManager manager, int periodicity) {
        this.manager = manager;
        this.gcPeriodicity = periodicity;
        this.initDisposalThread();
    }

    public synchronized void setManager(DisposableResourceManager manager) {
        if (manager == null) {
            this.stopDisposing(Long.MAX_VALUE);
        }
        this.manager = manager;
    }

    public DisposableResourceManager getManager() {
        return this.manager;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        if (this.manager == null) {
            throw new ResourceManagerNotSetException();
        }
        if (this.disposingActive) {
            return;
        }
        this.disposingActive = true;
        this.disposalThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDisposing(long millis) {
        if (!this.disposingActive) {
            return;
        }
        try {
            try {
                this.disposalThread.interruptDisposalPending = true;
                this.disposalThread.join(millis);
            }
            catch (InterruptedException ex) {
                Object var5_3 = null;
                this.disposingActive = false;
            }
            Object var5_2 = null;
            this.disposingActive = false;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.disposingActive = false;
            throw throwable;
        }
    }

    protected void initDisposalThread() {
        if (this.disposalThread != null) {
            return;
        }
        this.disposalThread = new DisposalThread(this, this.gcPeriodicity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dispose() {
        DisposableResourceManager disposableResourceManager = this.manager;
        synchronized (disposableResourceManager) {
            long currentTime = System.currentTimeMillis();
            Iterator resourceIter = this.manager.getResources();
            while (resourceIter.hasNext()) {
                DisposableResourceHolder resource;
                DisposableResourceHolder disposableResourceHolder = resource = (DisposableResourceHolder)resourceIter.next();
                synchronized (disposableResourceHolder) {
                    if (!resource.isLocked() && resource.getLastTimeAccessed() + resource.getDisposableDelay() < currentTime) {
                        resource.dispose();
                    }
                }
            }
        }
    }

    public long getPeriodicity() {
        return this.gcPeriodicity;
    }

    public void setPeriodicity(int newPeriodicity) {
        this.gcPeriodicity = newPeriodicity;
        if (this.disposalThread != null) {
            this.disposalThread.setPeriodicity(newPeriodicity);
        }
    }
}

