/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.DisposableResourceHolder;
import java.io.Serializable;

public class StandardDisposableResourceHolder
implements DisposableResourceHolder,
Serializable {
    protected Object resource = null;
    protected long disposeDelay = 60000L;
    protected long lastTimeAccessed = 0L;
    protected boolean isLocked = false;

    public StandardDisposableResourceHolder() {
    }

    public StandardDisposableResourceHolder(Object resource) {
        this.resource = resource;
        this.resetDelay();
    }

    public Object clone() {
        StandardDisposableResourceHolder clone = new StandardDisposableResourceHolder();
        clone.setDisposableDelay(this.getDisposableDelay());
        return clone;
    }

    public Object getResource() throws NullPointerException {
        if (this.resource != null) {
            this.resetDelay();
            return this.resource;
        }
        throw new NullPointerException();
    }

    public void setResource(Object resource) {
        this.resource = resource;
        this.resetDelay();
    }

    public void setDisposableDelay(long millis) {
        this.disposeDelay = millis;
    }

    public long getDisposableDelay() {
        return this.disposeDelay;
    }

    public void dispose() {
        this.resource = null;
    }

    public boolean isAvailable() {
        return this.resource != null;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void unlock() {
        this.resetDelay();
        this.isLocked = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public long getLastTimeAccessed() {
        return this.lastTimeAccessed;
    }

    public void resetDelay() {
        this.lastTimeAccessed = System.currentTimeMillis();
    }
}

