/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib.html;

import CH.ifa.draw.contrib.html.DisposableResourceHolder;
import CH.ifa.draw.contrib.html.DisposableResourceManager;
import CH.ifa.draw.contrib.html.ResourceDisposabilityStrategy;
import CH.ifa.draw.contrib.html.ResourceManagerNotSetException;
import java.util.Iterator;
import java.util.WeakHashMap;

public class StandardDisposableResourceManager
implements DisposableResourceManager {
    protected WeakHashMap resources = new WeakHashMap();
    protected ResourceDisposabilityStrategy strategy;

    public StandardDisposableResourceManager(ResourceDisposabilityStrategy strategy) {
        this.strategy = strategy;
        strategy.setManager(this);
    }

    public synchronized void registerResource(DisposableResourceHolder resource) {
        this.resources.put(resource, resource);
    }

    public synchronized void unregisterResource(DisposableResourceHolder resource) {
        this.resources.remove(resource);
    }

    public Iterator getResources() {
        return this.resources.values().iterator();
    }

    public synchronized boolean managesResource(DisposableResourceHolder resource) {
        return this.resources.containsValue(resource);
    }

    public ResourceDisposabilityStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ResourceDisposabilityStrategy newStrategy) {
        this.strategy = newStrategy;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        this.strategy.startDisposing();
    }

    public void stopDisposing(long millis) {
        this.strategy.stopDisposing(millis);
    }
}

