/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.BorderDecorator;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ActionTool;
import CH.ifa.draw.standard.DecoratorFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

public class BorderTool
extends ActionTool {
    public BorderTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        if ((e.getModifiers() & 2) == 0) {
            super.mouseDown(e, x, y);
        } else {
            Figure target = this.drawing().findFigure(x, y);
            if (target != null && target != target.getDecoratedFigure()) {
                this.view().addToSelection(target);
                this.reverseAction(target);
            }
        }
    }

    public void action(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List l = CollectionsFactory.current().createList();
        l.add(figure);
        l.add(new BorderDecorator(figure));
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(l));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    public void reverseAction(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List l = CollectionsFactory.current().createList();
        l.add(figure);
        l.add(((DecoratorFigure)figure).peelDecoration());
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(l));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean replaceAffectedFigures() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            Figure oldFigure = fe.nextFigure();
            if (!fe.hasNextFigure()) {
                return false;
            }
            Figure replaceFigure = fe.nextFigure();
            replaceFigure = this.getDrawingView().drawing().replace(oldFigure, replaceFigure);
            List l = CollectionsFactory.current().createList();
            l.add(replaceFigure);
            l.add(oldFigure);
            this.setAffectedFigures(new FigureEnumerator(l));
            return true;
        }
    }
}

