/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureVisitor;
import CH.ifa.draw.framework.HandleEnumeration;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.HandleEnumerator;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector myStartConnector;
    protected Connector myEndConnector;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    public boolean canConnect() {
        return false;
    }

    protected void basicMoveBy(int dx, int dy) {
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            this.pointAt(i).translate(dx, dy);
            ++i;
        }
        this.updateConnection();
    }

    public void connectStart(Connector newStartConnector) {
        this.setStartConnector(newStartConnector);
        if (newStartConnector != null) {
            this.startFigure().addDependendFigure(this);
            this.startFigure().addFigureChangeListener(this);
        }
    }

    public void connectEnd(Connector newEndConnector) {
        this.setEndConnector(newEndConnector);
        if (newEndConnector != null) {
            this.endFigure().addDependendFigure(this);
            this.endFigure().addFigureChangeListener(this);
            this.handleConnect(this.startFigure(), this.endFigure());
        }
    }

    public void disconnectStart() {
        this.startFigure().removeFigureChangeListener(this);
        this.startFigure().removeDependendFigure(this);
        this.setStartConnector(null);
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.endFigure().removeDependendFigure(this);
        this.setEndConnector(null);
    }

    public boolean connectsSame(ConnectionFigure other) {
        return other.getStartConnector() == this.getStartConnector() && other.getEndConnector() == this.getEndConnector();
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    public Figure startFigure() {
        if (this.getStartConnector() != null) {
            return this.getStartConnector().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.getEndConnector() != null) {
            return this.getEndConnector().owner();
        }
        return null;
    }

    protected void setStartConnector(Connector newStartConnector) {
        this.myStartConnector = newStartConnector;
    }

    public Connector getStartConnector() {
        return this.myStartConnector;
    }

    protected void setEndConnector(Connector newEndConnector) {
        this.myEndConnector = newEndConnector;
    }

    public Connector getEndConnector() {
        return this.myEndConnector;
    }

    public boolean canConnect(Figure start, Figure end) {
        return true;
    }

    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.add(new Point(x, y));
        } else {
            this.fPoints.set(0, new Point(x, y));
        }
        this.changed();
    }

    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.add(new Point(x, y));
        } else {
            this.fPoints.set(this.fPoints.size() - 1, new Point(x, y));
        }
        this.changed();
    }

    public Point startPoint() {
        Point p = this.pointAt(0);
        return new Point(p.x, p.y);
    }

    public Point endPoint() {
        if (this.fPoints.size() > 0) {
            Point p = this.pointAt(this.fPoints.size() - 1);
            return new Point(p.x, p.y);
        }
        return null;
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList(this.fPoints.size());
        handles.add(new ChangeConnectionStartHandle(this));
        int i = 1;
        while (i < this.fPoints.size() - 1) {
            handles.add(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
            ++i;
        }
        handles.add(new ChangeConnectionEndHandle(this));
        return new HandleEnumerator(handles);
    }

    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    public void updateConnection() {
        Point end;
        Point start;
        if (this.getStartConnector() != null && (start = this.getStartConnector().findStart(this)) != null) {
            this.startPoint(start.x, start.y);
        }
        if (this.getEndConnector() != null && (end = this.getEndConnector().findEnd(this)) != null) {
            this.endPoint(end.x, end.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.updateConnection();
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.getStartConnector() != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.getEndConnector() != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getStartConnector());
        dw.writeStorable(this.getEndConnector());
    }

    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.getStartConnector() != null) {
            this.connectStart(this.getStartConnector());
        }
        if (this.getEndConnector() != null) {
            this.connectEnd(this.getEndConnector());
        }
    }

    public void visit(FigureVisitor visitor) {
        visitor.visitFigure(this);
    }
}

