/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class RadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 4;

    public RadiusHandle(RoundRectangleFigure owner) {
        super(owner);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldRadius(((RoundRectangleFigure)this.owner()).getArc());
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int dx = x - anchorX;
        int dy = y - anchorY;
        RoundRectangleFigure owner = (RoundRectangleFigure)this.owner();
        Rectangle r = owner.displayBox();
        Point originalRadius = ((UndoActivity)this.getUndoActivity()).getOldRadius();
        int rx = Geom.range(0, r.width, 2 * (originalRadius.x / 2 + dx));
        int ry = Geom.range(0, r.height, 2 * (originalRadius.y / 2 + dy));
        owner.setArc(rx, ry);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point currentRadius = ((RoundRectangleFigure)this.owner()).getArc();
        Point originalRadius = ((UndoActivity)this.getUndoActivity()).getOldRadius();
        if (currentRadius.x == originalRadius.x && currentRadius.y == originalRadius.y) {
            this.setUndoActivity(null);
        }
    }

    public Point locate() {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.owner();
        Point radius = owner.getArc();
        Rectangle r = owner.displayBox();
        return new Point(r.x + radius.x / 2 + 4, r.y + radius.y / 2 + 4);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        return new UndoActivity(newView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOldRadius;

        public UndoActivity(DrawingView newView) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetRadius();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetRadius();
        }

        protected boolean resetRadius() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            RoundRectangleFigure currentFigure = (RoundRectangleFigure)fe.nextFigure();
            Point figureRadius = currentFigure.getArc();
            currentFigure.setArc(this.getOldRadius().x, this.getOldRadius().y);
            this.setOldRadius(figureRadius);
            return true;
        }

        protected void setOldRadius(Point newOldRadius) {
            this.myOldRadius = newOldRadius;
        }

        public Point getOldRadius() {
            return this.myOldRadius;
        }
    }
}

