/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import java.awt.event.MouseEvent;

public class ScribbleTool
extends AbstractTool {
    private PolyLineFigure fScribble;
    private int fLastX;
    private int fLastY;
    private Figure myAddedFigure;

    public ScribbleTool(DrawingEditor newDrawingEditor) {
        super(newDrawingEditor);
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        if (this.fScribble != null) {
            if (this.fScribble.size().width < 4 || this.fScribble.size().height < 4) {
                this.getActiveDrawing().remove(this.fScribble);
                this.setUndoActivity(null);
            }
            this.fScribble = null;
        }
    }

    private void point(int x, int y) {
        if (this.fScribble == null) {
            this.fScribble = new PolyLineFigure(x, y);
            this.setAddedFigure(this.view().add(this.fScribble));
        } else if (this.fLastX != x || this.fLastY != y) {
            this.fScribble.addPoint(x, y);
        }
        this.fLastX = x;
        this.fLastY = y;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        if (e.getClickCount() >= 2) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
        } else {
            this.point(e.getX(), e.getY());
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.fScribble != null) {
            this.point(e.getX(), e.getY());
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        if (e.getClickCount() >= 2) {
            this.editor().toolDone();
        }
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }
}

