/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    private FloatingTextField myTextField;
    private TextHolder myTypingTarget;
    private Figure mySelectedFigure;

    public TextTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        if (this.getTypingTarget() != null) {
            this.editor().toolDone();
            return;
        }
        TextHolder textHolder = null;
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure != null) {
            textHolder = pressedFigure.getTextHolder();
            this.setSelectedFigure(pressedFigure);
        }
        if (textHolder != null && textHolder.acceptsTyping()) {
            this.beginEdit(textHolder);
        } else {
            super.mouseDown(e, x, y);
            this.view().checkDamage();
            this.beginEdit(this.getCreatedFigure().getTextHolder());
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (!this.isActive()) {
            this.editor().toolDone();
        }
    }

    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    public void activate() {
        super.activate();
    }

    public boolean isActive() {
        return this.getTypingTarget() != null;
    }

    protected void beginEdit(TextHolder figure) {
        if (this.getFloatingTextField() == null) {
            this.setFloatingTextField(this.createFloatingTextField());
        }
        if (figure != this.getTypingTarget() && this.getTypingTarget() != null) {
            this.endEdit();
        }
        this.getFloatingTextField().createOverlay((Container)((Object)this.view()), figure.getFont());
        this.getFloatingTextField().setBounds(this.fieldBounds(figure), figure.getText());
        this.setTypingTarget(figure);
    }

    protected void endEdit() {
        if (this.getTypingTarget() != null) {
            if (this.getAddedFigure() != null) {
                if (!this.isDeleteTextFigure()) {
                    this.setUndoActivity(this.createPasteUndoActivity());
                    this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                    this.getTypingTarget().setText(this.getFloatingTextField().getText());
                }
            } else if (this.isDeleteTextFigure()) {
                this.setUndoActivity(this.createDeleteUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getSelectedFigure()));
                this.getUndoActivity().redo();
            } else {
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getTypingTarget().getRepresentingFigure()));
                this.getTypingTarget().setText(this.getFloatingTextField().getText());
                ((UndoActivity)this.getUndoActivity()).setBackupText(this.getTypingTarget().getText());
            }
            this.setTypingTarget(null);
            this.getFloatingTextField().endOverlay();
        } else {
            this.setUndoActivity(null);
        }
        this.setAddedFigure(null);
        this.setCreatedFigure(null);
        this.setSelectedFigure(null);
    }

    protected boolean isDeleteTextFigure() {
        return this.getFloatingTextField().getText().length() == 0;
    }

    private Rectangle fieldBounds(TextHolder figure) {
        Rectangle box = figure.textDisplayBox();
        int nChars = figure.overlayColumns();
        Dimension d = this.getFloatingTextField().getPreferredSize(nChars);
        return new Rectangle(box.x, box.y, d.width, d.height);
    }

    protected void setTypingTarget(TextHolder newTypingTarget) {
        this.myTypingTarget = newTypingTarget;
    }

    protected TextHolder getTypingTarget() {
        return this.myTypingTarget;
    }

    private void setSelectedFigure(Figure newSelectedFigure) {
        this.mySelectedFigure = newSelectedFigure;
    }

    protected Figure getSelectedFigure() {
        return this.mySelectedFigure;
    }

    private FloatingTextField createFloatingTextField() {
        return new FloatingTextField();
    }

    private void setFloatingTextField(FloatingTextField newFloatingTextField) {
        this.myTextField = newFloatingTextField;
    }

    protected FloatingTextField getFloatingTextField() {
        return this.myTextField;
    }

    protected Undoable createDeleteUndoActivity() {
        DeleteCommand cmd = new DeleteCommand("Delete", this.editor());
        return new DeleteCommand.UndoActivity(cmd);
    }

    protected Undoable createPasteUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private String myOriginalText;
        private String myBackupText;

        public UndoActivity(DrawingView newDrawingView, String newOriginalText) {
            super(newDrawingView);
            this.setOriginalText(newOriginalText);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setText(this.getOriginalText());
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setText(this.getBackupText());
            return true;
        }

        protected boolean isValidText(String toBeChecked) {
            return toBeChecked != null && toBeChecked.length() > 0;
        }

        protected void setText(String newText) {
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                currentFigure.getTextHolder().setText(newText);
            }
        }

        public void setBackupText(String newBackupText) {
            this.myBackupText = newBackupText;
        }

        public String getBackupText() {
            return this.myBackupText;
        }

        public void setOriginalText(String newOriginalText) {
            this.myOriginalText = newOriginalText;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }
    }
}

