/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.GroupFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;

public class UngroupCommand
extends AbstractCommand {
    public UngroupCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        this.view().clearSelection();
        ((UndoActivity)this.getUndoActivity()).ungroupFigures();
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        FigureEnumeration fe = this.view().selection();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            if ((currentFigure = currentFigure.getDecoratedFigure()) instanceof GroupFigure) continue;
            return false;
        }
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            FigureEnumeration groupFigures = this.getAffectedFigures();
            while (groupFigures.hasNextFigure()) {
                Figure groupFigure = groupFigures.nextFigure();
                this.getDrawingView().drawing().orphanAll(groupFigure.figures());
                Figure figure = this.getDrawingView().drawing().add(groupFigure);
                this.getDrawingView().addToSelection(figure);
            }
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
                this.getDrawingView().clearSelection();
                this.ungroupFigures();
                return true;
            }
            return false;
        }

        protected void ungroupFigures() {
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure selected = fe.nextFigure();
                Figure group = this.getDrawingView().drawing().orphan(selected);
                this.getDrawingView().drawing().addAll(group.figures());
                this.getDrawingView().addToSelectionAll(group.figures());
            }
        }
    }
}

