/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.ClippingUpdateStrategy;
import CH.ifa.draw.contrib.ComponentFigure;
import CH.ifa.draw.contrib.CompositeFigureCreationTool;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.GraphicalCompositeFigure;
import CH.ifa.draw.contrib.MDIDesktopPane;
import CH.ifa.draw.contrib.MDI_DrawApplication;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.SimpleLayouter;
import CH.ifa.draw.contrib.SplitConnectionTool;
import CH.ifa.draw.contrib.TextAreaFigure;
import CH.ifa.draw.contrib.TextAreaTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.contrib.WindowMenu;
import CH.ifa.draw.contrib.html.HTMLTextAreaFigure;
import CH.ifa.draw.contrib.html.HTMLTextAreaTool;
import CH.ifa.draw.contrib.zoom.ZoomDrawingView;
import CH.ifa.draw.contrib.zoom.ZoomTool;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.InsertImageCommand;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.samples.javadraw.Animator;
import CH.ifa.draw.samples.javadraw.BouncingDrawing;
import CH.ifa.draw.samples.javadraw.MySelectionTool;
import CH.ifa.draw.samples.javadraw.URLTool;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.util.Animatable;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.UndoableCommand;
import CH.ifa.draw.util.UndoableTool;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class JavaDrawApp
extends MDI_DrawApplication {
    private Animator fAnimator;
    private static String fgSampleImagesPath = "/CH/ifa/draw/samples/javadraw/sampleimages";
    private static String fgSampleImagesResourcePath = fgSampleImagesPath + "/";

    JavaDrawApp() {
        super("JHotDraw");
    }

    public JavaDrawApp(String title) {
        super(title);
    }

    protected DrawApplication createApplication() {
        return new JavaDrawApp();
    }

    protected DrawingView createDrawingView() {
        return new ZoomDrawingView(this);
    }

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        Tool tool = new ZoomTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/ZOOM", "Zoom Tool", tool));
        tool = new UndoableTool(new TextTool(this, new TextFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool));
        tool = new UndoableTool(new ConnectedTextTool(this, new TextFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RectangleFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RoundRectangleFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new EllipseFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new UndoableTool(new PolygonTool(this));
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new TriangleFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new DiamondFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new LineFigure()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new LineConnection()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new ElbowConnection()));
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new UndoableTool(new ScribbleTool(this));
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new UndoableTool(new BorderTool(this));
        palette.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", tool));
        JButton button = new JButton("Hello World");
        tool = new CreationTool(this, new ComponentFigure(button));
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Component Tool", tool));
        tool = new TextAreaTool(this, new TextAreaFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXTAREA", "TextArea Tool", tool));
        GraphicalCompositeFigure fig = new GraphicalCompositeFigure();
        fig.setLayouter(new SimpleLayouter(fig));
        tool = new CreationTool(this, fig);
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Container Figure Tool", tool));
        tool = new CompositeFigureCreationTool(this, new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Nested Figure Tool", tool));
        tool = new HTMLTextAreaTool(this, new HTMLTextAreaFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXTAREA", "HTML TextArea Tool", tool));
        LineConnection lineConnection = new LineConnection();
        lineConnection.setStartDecoration(null);
        tool = new UndoableTool(new SplitConnectionTool(this, lineConnection));
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Split Connection Tool", tool));
    }

    protected Tool createSelectionTool() {
        return new MySelectionTool(this);
    }

    protected void createMenus(JMenuBar mb) {
        super.createMenus(mb);
        this.addMenuIfPossible(mb, this.createAnimationMenu());
        this.addMenuIfPossible(mb, this.createImagesMenu());
        this.addMenuIfPossible(mb, this.createWindowMenu());
    }

    protected JMenu createAnimationMenu() {
        CommandMenu menu = new CommandMenu("Animation");
        AbstractCommand cmd = new AbstractCommand("Start Animation", this){

            public void execute() {
                JavaDrawApp.this.startAnimation();
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("Stop Animation", this){

            public void execute() {
                JavaDrawApp.this.endAnimation();
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createWindowMenu() {
        CommandMenu menu = new CommandMenu("Window");
        AbstractCommand cmd = new AbstractCommand("New View", this){

            public void execute() {
                JavaDrawApp.this.newView();
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("New Window", this, false){

            public void execute() {
                JavaDrawApp.this.newWindow(JavaDrawApp.this.createDrawing());
            }
        };
        menu.add(cmd);
        menu.addSeparator();
        menu.add(new WindowMenu("Window List", (MDIDesktopPane)this.getDesktop(), this));
        return menu;
    }

    protected JMenu createImagesMenu() {
        CommandMenu menu = new CommandMenu("Images");
        URL url = this.getClass().getResource(fgSampleImagesPath);
        File imagesDirectory = new File(url.getFile());
        try {
            String[] list = imagesDirectory.list();
            int i = 0;
            while (i < list.length) {
                String name = list[i];
                String path = fgSampleImagesResourcePath + name;
                menu.add(new UndoableCommand(new InsertImageCommand(name, path, this)));
                ++i;
            }
        }
        catch (Exception e) {}
        return menu;
    }

    protected Drawing createDrawing() {
        BouncingDrawing dwg = new BouncingDrawing();
        dwg.setTitle(this.getDefaultDrawingTitle());
        return dwg;
    }

    public void startAnimation() {
        if (this.view().drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.view().drawing()), this.view());
            this.fAnimator.start();
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
        }
    }

    protected JMenu createDebugMenu() {
        CommandMenu menu = (CommandMenu)super.createDebugMenu();
        AbstractCommand cmd = new AbstractCommand("Clipping Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new ClippingUpdateStrategy());
            }
        };
        menu.add(cmd);
        return menu;
    }

    public static void main(String[] args) {
        JavaDrawApp window = new JavaDrawApp();
        window.open();
    }
}

