/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.applet.DrawApplet;
import CH.ifa.draw.contrib.DiamondFigure;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.samples.javadraw.Animator;
import CH.ifa.draw.samples.javadraw.BouncingDrawing;
import CH.ifa.draw.samples.javadraw.URLTool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.util.Animatable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class JavaDrawApplet
extends DrawApplet {
    private transient JButton fAnimationButton;
    private transient Animator fAnimator;

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JPanel palette) {
        super.createTools(palette);
        AbstractTool tool = new TextTool(this, new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", tool));
        tool = new ConnectedTextTool(this, new TextFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", tool));
        tool = new CreationTool(this, new RectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", tool));
        tool = new CreationTool(this, new RoundRectangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new CreationTool(this, new EllipseFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new PolygonTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new CreationTool(this, new TriangleFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new CreationTool(this, new DiamondFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/DIAMOND", "Diamond Tool", tool));
        tool = new CreationTool(this, new LineFigure());
        palette.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", tool));
        tool = new ConnectionTool(this, new LineConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", tool));
        tool = new ConnectionTool(this, new ElbowConnection());
        palette.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new ScribbleTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new PolygonTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", tool));
        tool = new BorderTool(this);
        palette.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", tool));
    }

    protected void createButtons(JPanel panel) {
        super.createButtons(panel);
        this.fAnimationButton = new JButton("Start Animation");
        this.fAnimationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JavaDrawApplet.this.toggleAnimation();
            }
        });
        panel.add(this.fAnimationButton);
    }

    protected Drawing createDrawing() {
        return new BouncingDrawing();
    }

    public void startAnimation() {
        if (this.drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.drawing()), this.view());
            this.fAnimator.start();
            this.fAnimationButton.setText("End Animation");
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
            this.fAnimationButton.setText("Start Animation");
        }
    }

    public void toggleAnimation() {
        if (this.fAnimator != null) {
            this.endAnimation();
        } else {
            this.startAnimation();
        }
    }
}

