/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.javadraw;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureAttributeConstant;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.FloatingTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class URLTool
extends AbstractTool {
    private FloatingTextField fTextField;
    private Figure fURLTarget;

    public URLTool(DrawingEditor newDrawingEditor) {
        super(newDrawingEditor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        Figure pressedFigure = this.drawing().findFigureInside(x, y);
        if (pressedFigure != null) {
            this.beginEdit(pressedFigure);
            return;
        }
        this.endEdit();
        this.editor().toolDone();
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void deactivate(DrawingView view) {
        super.deactivate();
        this.endEdit();
    }

    private void beginEdit(Figure figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
            this.fTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    URLTool.this.endEdit();
                }
            });
        }
        if (figure != this.fURLTarget && this.fURLTarget != null) {
            this.endEdit();
        }
        if (figure != this.fURLTarget) {
            this.fTextField.createOverlay((Container)((Object)this.view()));
            this.fTextField.setBounds(this.fieldBounds(figure), this.getURL(figure));
            this.fURLTarget = figure;
        }
    }

    private void endEdit() {
        if (this.fURLTarget != null) {
            this.setURL(this.fURLTarget, this.fTextField.getText());
            this.fURLTarget = null;
            this.fTextField.endOverlay();
        }
    }

    private Rectangle fieldBounds(Figure figure) {
        Rectangle box = figure.displayBox();
        int nChars = Math.max(20, this.getURL(figure).length());
        Dimension d = this.fTextField.getPreferredSize(nChars);
        box.x = Math.max(0, box.x + (box.width - d.width) / 2);
        box.y = Math.max(0, box.y + (box.height - d.height) / 2);
        return new Rectangle(box.x, box.y, d.width, d.height);
    }

    private String getURL(Figure figure) {
        String url = (String)figure.getAttribute(FigureAttributeConstant.URL);
        if (url == null) {
            url = "";
        }
        return url;
    }

    private void setURL(Figure figure, String url) {
        figure.setAttribute(FigureAttributeConstant.URL, (Object)url);
    }
}

