/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.samples.pert;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureAttributeConstant;
import CH.ifa.draw.framework.HandleEnumeration;
import CH.ifa.draw.samples.pert.PertFigure;
import CH.ifa.draw.standard.HandleEnumerator;
import CH.ifa.draw.standard.NullHandle;
import java.awt.Color;
import java.util.List;

public class PertDependency
extends LineConnection {
    private static final long serialVersionUID = -7959500008698525009L;
    private int pertDependencySerializedDataVersion = 1;

    public PertDependency() {
        this.setEndDecoration(new ArrowTip());
        this.setStartDecoration(null);
    }

    public void handleConnect(Figure start, Figure end) {
        PertFigure source = (PertFigure)start;
        PertFigure target = (PertFigure)end;
        if (source.hasCycle(target)) {
            this.setAttribute(FigureAttributeConstant.FRAME_COLOR.getName(), (Object)Color.red);
        } else {
            target.addPreTask(source);
            source.addPostTask(target);
            source.notifyPostTasks();
        }
    }

    public void handleDisconnect(Figure start, Figure end) {
        PertFigure source = (PertFigure)start;
        PertFigure target = (PertFigure)end;
        if (target != null) {
            target.removePreTask(source);
            target.updateDurations();
        }
        if (source != null) {
            source.removePostTask(target);
        }
    }

    public boolean canConnect(Figure start, Figure end) {
        return start instanceof PertFigure && end instanceof PertFigure;
    }

    public HandleEnumeration handles() {
        List handles = super.handles().toList();
        handles.set(0, new NullHandle(this, PolyLineFigure.locator(0)));
        return new HandleEnumerator(handles);
    }
}

