/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureSelectionListener;
import CH.ifa.draw.framework.JHotDrawRuntimeException;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandListener;
import CH.ifa.draw.util.Undoable;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCommand
implements Command,
FigureSelectionListener,
ViewChangeListener {
    private String myName;
    private Undoable myUndoableActivity;
    private boolean myIsViewRequired;
    private EventDispatcher myEventDispatcher;
    private DrawingEditor myDrawingEditor;

    public AbstractCommand(String newName, DrawingEditor newDrawingEditor) {
        this(newName, newDrawingEditor, true);
    }

    public AbstractCommand(String newName, DrawingEditor newDrawingEditor, boolean newIsViewRequired) {
        this.setName(newName);
        this.setDrawingEditor(newDrawingEditor);
        this.getDrawingEditor().addViewChangeListener(this);
        this.myIsViewRequired = newIsViewRequired;
        this.setEventDispatcher(this.createEventDispatcher());
    }

    public void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
        if (oldView != null) {
            oldView.removeFigureSelectionListener(this);
        }
        if (newView != null) {
            newView.addFigureSelectionListener(this);
        }
        if (this.isViewRequired()) {
            boolean isNewViewInteractive;
            boolean isOldViewInteractive = oldView != null && oldView.isInteractive();
            boolean bl = isNewViewInteractive = newView != null && newView.isInteractive();
            if (!isOldViewInteractive && isNewViewInteractive) {
                this.getEventDispatcher().fireCommandExecutableEvent();
            } else if (isOldViewInteractive && !isNewViewInteractive) {
                this.getEventDispatcher().fireCommandNotExecutableEvent();
            }
        }
    }

    public void viewCreated(DrawingView view) {
    }

    public void viewDestroying(DrawingView view) {
    }

    public void figureSelectionChanged(DrawingView view) {
    }

    public DrawingEditor getDrawingEditor() {
        return this.myDrawingEditor;
    }

    private void setDrawingEditor(DrawingEditor newDrawingEditor) {
        this.myDrawingEditor = newDrawingEditor;
    }

    public DrawingView view() {
        return this.getDrawingEditor().view();
    }

    public String name() {
        return this.myName;
    }

    public void setName(String newName) {
        this.myName = newName;
    }

    public void dispose() {
        if (this.view() != null) {
            this.view().removeFigureSelectionListener(this);
        }
    }

    public void execute() {
        if (this.view() == null) {
            throw new JHotDrawRuntimeException("execute should NOT be getting called when view() == null");
        }
    }

    public boolean isExecutable() {
        if (this.isViewRequired() && (this.view() == null || !this.view().isInteractive())) {
            return false;
        }
        return this.isExecutableWithView();
    }

    protected boolean isViewRequired() {
        return this.myIsViewRequired;
    }

    protected boolean isExecutableWithView() {
        return true;
    }

    public Undoable getUndoActivity() {
        return this.myUndoableActivity;
    }

    public void setUndoActivity(Undoable newUndoableActivity) {
        this.myUndoableActivity = newUndoableActivity;
    }

    public void addCommandListener(CommandListener newCommandListener) {
        this.getEventDispatcher().addCommandListener(newCommandListener);
    }

    public void removeCommandListener(CommandListener oldCommandListener) {
        this.getEventDispatcher().removeCommandListener(oldCommandListener);
    }

    private void setEventDispatcher(EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    public static class EventDispatcher {
        private List myRegisteredListeners = CollectionsFactory.current().createList();
        private Command myObservedCommand;

        public EventDispatcher(Command newObservedCommand) {
            this.myObservedCommand = newObservedCommand;
        }

        public void fireCommandExecutedEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((CommandListener)iter.next()).commandExecuted(new EventObject(this.myObservedCommand));
            }
        }

        public void fireCommandExecutableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((CommandListener)iter.next()).commandExecutable(new EventObject(this.myObservedCommand));
            }
        }

        public void fireCommandNotExecutableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((CommandListener)iter.next()).commandNotExecutable(new EventObject(this.myObservedCommand));
            }
        }

        public void addCommandListener(CommandListener newCommandListener) {
            if (!this.myRegisteredListeners.contains(newCommandListener)) {
                this.myRegisteredListeners.add(newCommandListener);
            }
        }

        public void removeCommandListener(CommandListener oldCommandListener) {
            if (this.myRegisteredListeners.contains(oldCommandListener)) {
                this.myRegisteredListeners.remove(oldCommandListener);
            }
        }
    }
}

