/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ToolListener;
import CH.ifa.draw.framework.ViewChangeListener;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Undoable;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTool
implements Tool,
ViewChangeListener {
    private DrawingEditor myDrawingEditor;
    private int myAnchorX;
    private int myAnchorY;
    private DrawingView myDrawingView;
    private Undoable myUndoActivity;
    private EventDispatcher myEventDispatcher;
    private boolean myIsUsable;
    private boolean myIsEnabled;

    public AbstractTool(DrawingEditor newDrawingEditor) {
        this.myDrawingEditor = newDrawingEditor;
        this.setEventDispatcher(this.createEventDispatcher());
        this.setEnabled(true);
        this.checkUsable();
        this.editor().addViewChangeListener(this);
    }

    public void activate() {
        if (this.getActiveView() != null) {
            this.getActiveView().clearSelection();
            this.getActiveView().checkDamage();
            this.getEventDispatcher().fireToolActivatedEvent();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            if (this.getActiveView() != null) {
                this.getActiveView().setCursor(Cursor.getDefaultCursor());
            }
            this.getEventDispatcher().fireToolDeactivatedEvent();
        }
    }

    public void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
        if (this.isActive()) {
            this.deactivate();
            this.activate();
        }
        this.checkUsable();
    }

    public void viewCreated(DrawingView view) {
    }

    public void viewDestroying(DrawingView view) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setAnchorX(x);
        this.setAnchorY(y);
        this.setView((DrawingView)e.getSource());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
    }

    public void keyDown(KeyEvent evt, int key) {
    }

    public Drawing drawing() {
        return this.view().drawing();
    }

    public Drawing getActiveDrawing() {
        return this.getActiveView().drawing();
    }

    public DrawingEditor editor() {
        return this.myDrawingEditor;
    }

    protected void setEditor(DrawingEditor newDrawingEditor) {
        this.myDrawingEditor = newDrawingEditor;
    }

    public DrawingView view() {
        return this.myDrawingView;
    }

    protected void setView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }

    public DrawingView getActiveView() {
        return this.editor().view();
    }

    public boolean isUsable() {
        return this.isEnabled() && this.myIsUsable;
    }

    public void setUsable(boolean newIsUsable) {
        if (this.isUsable() != newIsUsable) {
            this.myIsUsable = newIsUsable;
            if (this.isUsable()) {
                this.getEventDispatcher().fireToolUsableEvent();
            } else {
                this.getEventDispatcher().fireToolUnusableEvent();
            }
        }
    }

    public void setEnabled(boolean newIsEnabled) {
        if (this.isEnabled() != newIsEnabled) {
            this.myIsEnabled = newIsEnabled;
            if (this.isEnabled()) {
                this.getEventDispatcher().fireToolEnabledEvent();
            } else {
                this.getEventDispatcher().fireToolDisabledEvent();
                this.setUsable(false);
                this.deactivate();
            }
        }
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    protected void setAnchorX(int newAnchorX) {
        this.myAnchorX = newAnchorX;
    }

    protected int getAnchorX() {
        return this.myAnchorX;
    }

    protected void setAnchorY(int newAnchorY) {
        this.myAnchorY = newAnchorY;
    }

    protected int getAnchorY() {
        return this.myAnchorY;
    }

    public Undoable getUndoActivity() {
        return this.myUndoActivity;
    }

    public void setUndoActivity(Undoable newUndoActivity) {
        this.myUndoActivity = newUndoActivity;
    }

    public boolean isActive() {
        return this.editor().tool() == this && this.isUsable();
    }

    public void addToolListener(ToolListener newToolListener) {
        this.getEventDispatcher().addToolListener(newToolListener);
    }

    public void removeToolListener(ToolListener oldToolListener) {
        this.getEventDispatcher().removeToolListener(oldToolListener);
    }

    private void setEventDispatcher(EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    protected void checkUsable() {
        if (this.isEnabled()) {
            this.setUsable(this.getActiveView() != null && this.getActiveView().isInteractive());
        }
    }

    public static class EventDispatcher {
        private List myRegisteredListeners = CollectionsFactory.current().createList();
        private Tool myObservedTool;

        public EventDispatcher(Tool newObservedTool) {
            this.myObservedTool = newObservedTool;
        }

        public void fireToolUsableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolUsable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolUnusableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolUnusable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolActivatedEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolActivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDeactivatedEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolDeactivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolEnabledEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolEnabled(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDisabledEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolDisabled(new EventObject(this.myObservedTool));
            }
        }

        public void addToolListener(ToolListener newToolListener) {
            if (!this.myRegisteredListeners.contains(newToolListener)) {
                this.myRegisteredListeners.add(newToolListener);
            }
        }

        public void removeToolListener(ToolListener oldToolListener) {
            if (this.myRegisteredListeners.contains(oldToolListener)) {
                this.myRegisteredListeners.remove(oldToolListener);
            }
        }
    }
}

