/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;

public class AlignCommand
extends AbstractCommand {
    private Alignment myAlignment;

    public AlignCommand(Alignment newAlignment, DrawingEditor newDrawingEditor) {
        super(newAlignment.getDescription(), newDrawingEditor);
        this.setAlignment(newAlignment);
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 1;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        ((UndoActivity)this.getUndoActivity()).alignAffectedFigures(this.getAlignment());
        this.view().checkDamage();
    }

    protected void setAlignment(Alignment newAlignment) {
        this.myAlignment = newAlignment;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getAlignment());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalPoints = new Hashtable();
        private Alignment myAppliedAlignment;

        public UndoActivity(DrawingView newView, Alignment newAlignment) {
            super(newView);
            this.setAppliedAlignment(newAlignment);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                Point originalPoint = this.getOriginalPoint(f);
                Point currentPoint = f.displayBox().getLocation();
                f.moveBy(-currentPoint.x + originalPoint.x, -currentPoint.y + originalPoint.y);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.alignAffectedFigures(this.getAppliedAlignment());
            return true;
        }

        protected void setAppliedAlignment(Alignment newAlignment) {
            this.myAppliedAlignment = newAlignment;
        }

        public Alignment getAppliedAlignment() {
            return this.myAppliedAlignment;
        }

        protected void addOriginalPoint(Figure f) {
            this.myOriginalPoints.put(f, f.displayBox().getLocation());
        }

        public Point getOriginalPoint(Figure f) {
            return (Point)this.myOriginalPoints.get(f);
        }

        public void alignAffectedFigures(Alignment applyAlignment) {
            FigureEnumeration fe = this.getAffectedFigures();
            Figure anchorFigure = fe.nextFigure();
            Rectangle r = anchorFigure.displayBox();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                applyAlignment.moveBy(f, r);
            }
        }

        public void setAffectedFigures(FigureEnumeration fe) {
            super.setAffectedFigures(fe);
            FigureEnumeration copyFe = this.getAffectedFigures();
            while (copyFe.hasNextFigure()) {
                this.addOriginalPoint(copyFe.nextFigure());
            }
        }
    }

    public static abstract class Alignment {
        public static final Alignment LEFTS = new Alignment("Lefts"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(anchor.x - rr.x, 0);
            }
        };
        public static final Alignment CENTERS = new Alignment("Centers"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(anchor.x + anchor.width / 2 - (rr.x + rr.width / 2), 0);
            }
        };
        public static final Alignment RIGHTS = new Alignment("Rights"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(anchor.x + anchor.width - (rr.x + rr.width), 0);
            }
        };
        public static final Alignment TOPS = new Alignment("Tops"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(0, anchor.y - rr.y);
            }
        };
        public static final Alignment MIDDLES = new Alignment("Middles"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(0, anchor.y + anchor.height / 2 - (rr.y + rr.height / 2));
            }
        };
        public static final Alignment BOTTOMS = new Alignment("Bottoms"){

            public void moveBy(Figure f, Rectangle anchor) {
                Rectangle rr = f.displayBox();
                f.moveBy(0, anchor.y + anchor.height - (rr.y + rr.height));
            }
        };
        private String myDescription;

        private Alignment(String newDescription) {
            this.setDescription(newDescription);
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return this.myDescription;
        }

        private void setDescription(String newDescription) {
            this.myDescription = newDescription;
        }

        public abstract void moveBy(Figure var1, Rectangle var2);
    }
}

