/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureAttributeConstant;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.util.Hashtable;

public class ChangeAttributeCommand
extends AbstractCommand {
    private FigureAttributeConstant fAttribute;
    private Object fValue;

    public ChangeAttributeCommand(String name, FigureAttributeConstant attribute, Object value, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
        this.fAttribute = attribute;
        this.fValue = value;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        FigureEnumeration fe = this.getUndoActivity().getAffectedFigures();
        while (fe.hasNextFigure()) {
            fe.nextFigure().setAttribute(this.fAttribute, this.fValue);
        }
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.fAttribute, this.fValue);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureAttributeConstant myUndoAttribute;
        private Hashtable myOriginalValues = new Hashtable();
        private Object myUndoValue;

        public UndoActivity(DrawingView newDrawingView, FigureAttributeConstant newUndoAttribute, Object newUndoValue) {
            super(newDrawingView);
            this.setAttribute(newUndoAttribute);
            this.setBackupValue(newUndoValue);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                if (this.getOriginalValue(f) == null) continue;
                f.setAttribute(this.getAttribute(), this.getOriginalValue(f));
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure f = fe.nextFigure();
                if (this.getBackupValue() == null) continue;
                f.setAttribute(this.getAttribute(), this.getBackupValue());
            }
            return true;
        }

        protected void addOriginalValue(Figure affectedFigure, Object newOriginalValue) {
            this.myOriginalValues.put(affectedFigure, newOriginalValue);
        }

        protected Object getOriginalValue(Figure lookupAffectedFigure) {
            return this.myOriginalValues.get(lookupAffectedFigure);
        }

        protected void setAttribute(FigureAttributeConstant newUndoAttribute) {
            this.myUndoAttribute = newUndoAttribute;
        }

        public FigureAttributeConstant getAttribute() {
            return this.myUndoAttribute;
        }

        protected void setBackupValue(Object newUndoValue) {
            this.myUndoValue = newUndoValue;
        }

        public Object getBackupValue() {
            return this.myUndoValue;
        }

        public void release() {
            super.release();
            this.myOriginalValues = null;
        }

        public void setAffectedFigures(FigureEnumeration fe) {
            super.setAffectedFigures(fe);
            FigureEnumeration copyFe = this.getAffectedFigures();
            while (copyFe.hasNextFigure()) {
                Figure f = copyFe.nextFigure();
                Object attributeValue = f.getAttribute(this.getAttribute());
                if (attributeValue == null) continue;
                this.addOriginalValue(f, attributeValue);
            }
        }
    }
}

