/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure myConnection;
    private ConnectionFigure fPrototype;
    private Figure myTargetFigure;

    public ConnectionHandle(Figure owner, Locator l, ConnectionFigure prototype) {
        super(owner, l);
        this.fPrototype = prototype;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setConnection(this.createConnection());
        Point p = this.locate();
        this.getConnection().startPoint(p.x, p.y);
        this.getConnection().endPoint(p.x, p.y);
        view.drawing().add(this.getConnection());
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(f);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.getConnection().endPoint(p.x, p.y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target != null) {
            this.getConnection().connectStart(this.startConnector());
            this.getConnection().connectEnd(target);
            this.getConnection().updateConnection();
        } else {
            view.drawing().remove(this.getConnection());
        }
        this.setConnection(null);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector startConnector() {
        Point p = this.locate();
        return this.owner().connectorAt(p.x, p.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && !target.includes(this.owner()) && this.getConnection().canConnect(this.owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration fe = drawing.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.myConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected Figure getTargetFigure() {
        return this.myTargetFigure;
    }

    protected void setTargetFigure(Figure newTargetFigure) {
        this.myTargetFigure = newTargetFigure;
    }
}

