/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.JHotDrawRuntimeException;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class CreationTool
extends AbstractTool {
    private Figure fCreatedFigure;
    private Figure myAddedFigure;
    private Figure myPrototypeFigure;

    public CreationTool(DrawingEditor newDrawingEditor, Figure prototype) {
        super(newDrawingEditor);
        this.setPrototypeFigure(prototype);
    }

    protected CreationTool(DrawingEditor newDrawingEditor) {
        this(newDrawingEditor, null);
    }

    public void activate() {
        super.activate();
        if (this.isUsable()) {
            this.getActiveView().setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.setCreatedFigure(this.createFigure());
        this.setAddedFigure(this.view().add(this.getCreatedFigure()));
        this.getAddedFigure().displayBox(new Point(this.getAnchorX(), this.getAnchorY()), new Point(this.getAnchorX(), this.getAnchorY()));
    }

    protected Figure createFigure() {
        if (this.getPrototypeFigure() == null) {
            throw new JHotDrawRuntimeException("No protoype defined");
        }
        return (Figure)this.getPrototypeFigure().clone();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.getAddedFigure() != null) {
            this.getAddedFigure().displayBox(new Point(this.getAnchorX(), this.getAnchorY()), new Point(x, y));
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.getAddedFigure() != null) {
            if (this.getCreatedFigure().isEmpty()) {
                this.drawing().remove(this.getAddedFigure());
                this.setUndoActivity(null);
            } else {
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
            }
            this.setAddedFigure(null);
        }
        this.setCreatedFigure(null);
        this.editor().toolDone();
    }

    protected void setPrototypeFigure(Figure newPrototypeFigure) {
        this.myPrototypeFigure = newPrototypeFigure;
    }

    protected Figure getPrototypeFigure() {
        return this.myPrototypeFigure;
    }

    protected Figure getCreatedFigure() {
        return this.fCreatedFigure;
    }

    protected void setCreatedFigure(Figure newCreatedFigure) {
        this.fCreatedFigure = newCreatedFigure;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    protected void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }
}

