/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.FigureTransferCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;

public class CutCommand
extends FigureTransferCommand {
    public CutCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        this.copyFigures(this.getUndoActivity().getAffectedFigures(), this.view().selectionCount());
        this.deleteFigures(this.getUndoActivity().getAffectedFigures());
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureTransferCommand myCommand;

        public UndoActivity(FigureTransferCommand newCommand) {
            super(newCommand.view());
            this.myCommand = newCommand;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (super.undo() && this.getAffectedFigures().hasNextFigure()) {
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(this.myCommand.insertFigures(this.getAffectedFigures(), 0, 0));
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.myCommand.copyFigures(this.getAffectedFigures(), this.getDrawingView().selectionCount());
                this.myCommand.deleteFigures(this.getAffectedFigures());
                return true;
            }
            return false;
        }
    }
}

