/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureVisitor;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.CollectionsFactory;
import java.util.Set;

public class DeleteFromDrawingVisitor
implements FigureVisitor {
    private Set myDeletedFigures = CollectionsFactory.current().createSet();
    private Drawing myDrawing;

    public DeleteFromDrawingVisitor(Drawing newDrawing) {
        this.setDrawing(newDrawing);
    }

    private void setDrawing(Drawing newDrawing) {
        this.myDrawing = newDrawing;
    }

    protected Drawing getDrawing() {
        return this.myDrawing;
    }

    public void visitFigure(Figure hostFigure) {
        if (!this.myDeletedFigures.contains(hostFigure) && this.getDrawing().containsFigure(hostFigure)) {
            Figure orphanedFigure = this.getDrawing().orphan(hostFigure);
            this.myDeletedFigures.add(orphanedFigure);
        }
    }

    public void visitHandle(Handle hostHandle) {
    }

    public void visitFigureChangeListener(FigureChangeListener hostFigureChangeListener) {
    }

    public FigureEnumeration getDeletedFigures() {
        return new FigureEnumerator(this.myDeletedFigures);
    }
}

