/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.DeleteFromDrawingVisitor;
import CH.ifa.draw.standard.StandardFigureSelection;
import CH.ifa.draw.util.Clipboard;

public abstract class FigureTransferCommand
extends AbstractCommand {
    protected FigureTransferCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    protected void deleteFigures(FigureEnumeration fe) {
        DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(this.view().drawing());
        while (fe.hasNextFigure()) {
            fe.nextFigure().visit(deleteVisitor);
        }
        this.view().clearSelection();
    }

    protected void copyFigures(FigureEnumeration fe, int figureCount) {
        Clipboard.getClipboard().setContents(new StandardFigureSelection(fe, figureCount));
    }

    public FigureEnumeration insertFigures(FigureEnumeration fe, int dx, int dy) {
        return this.view().insertFigures(fe, dx, dy, false);
    }
}

