/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.CollectionsFactory;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class QuadTree
implements Serializable {
    private Rectangle2D _absoluteBoundingRectangle2D = new Rectangle2D.Double();
    private int _nMaxTreeDepth;
    private Hashtable _theHashtable = new Hashtable();
    private Hashtable _outsideHashtable = new Hashtable();
    private QuadTree _nwQuadTree;
    private QuadTree _neQuadTree;
    private QuadTree _swQuadTree;
    private QuadTree _seQuadTree;

    public QuadTree(Rectangle2D absoluteBoundingRectangle2D) {
        this(2, absoluteBoundingRectangle2D);
    }

    public QuadTree(int nMaxTreeDepth, Rectangle2D absoluteBoundingRectangle2D) {
        this._init(nMaxTreeDepth, absoluteBoundingRectangle2D);
    }

    public void add(Object anObject, Rectangle2D absoluteBoundingRectangle2D) {
        if (this._nMaxTreeDepth == 1) {
            if (absoluteBoundingRectangle2D.intersects(this._absoluteBoundingRectangle2D)) {
                this._theHashtable.put(anObject, absoluteBoundingRectangle2D);
            } else {
                this._outsideHashtable.put(anObject, absoluteBoundingRectangle2D);
            }
            return;
        }
        boolean bNW = absoluteBoundingRectangle2D.intersects(this._nwQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bNE = absoluteBoundingRectangle2D.intersects(this._neQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bSW = absoluteBoundingRectangle2D.intersects(this._swQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bSE = absoluteBoundingRectangle2D.intersects(this._seQuadTree.getAbsoluteBoundingRectangle2D());
        int nCount = 0;
        if (bNW) {
            ++nCount;
        }
        if (bNE) {
            ++nCount;
        }
        if (bSW) {
            ++nCount;
        }
        if (bSE) {
            ++nCount;
        }
        if (nCount > 1) {
            this._theHashtable.put(anObject, absoluteBoundingRectangle2D);
            return;
        }
        if (nCount == 0) {
            this._outsideHashtable.put(anObject, absoluteBoundingRectangle2D);
            return;
        }
        if (bNW) {
            this._nwQuadTree.add(anObject, absoluteBoundingRectangle2D);
        }
        if (bNE) {
            this._neQuadTree.add(anObject, absoluteBoundingRectangle2D);
        }
        if (bSW) {
            this._swQuadTree.add(anObject, absoluteBoundingRectangle2D);
        }
        if (bSE) {
            this._seQuadTree.add(anObject, absoluteBoundingRectangle2D);
        }
    }

    public Object remove(Object anObject) {
        Object returnObject = this._theHashtable.remove(anObject);
        if (returnObject != null) {
            return returnObject;
        }
        if (this._nMaxTreeDepth > 1) {
            returnObject = this._nwQuadTree.remove(anObject);
            if (returnObject != null) {
                return returnObject;
            }
            returnObject = this._neQuadTree.remove(anObject);
            if (returnObject != null) {
                return returnObject;
            }
            returnObject = this._swQuadTree.remove(anObject);
            if (returnObject != null) {
                return returnObject;
            }
            returnObject = this._seQuadTree.remove(anObject);
            if (returnObject != null) {
                return returnObject;
            }
        }
        if ((returnObject = this._outsideHashtable.remove(anObject)) != null) {
            return returnObject;
        }
        return null;
    }

    public void clear() {
        this._theHashtable.clear();
        this._outsideHashtable.clear();
        if (this._nMaxTreeDepth > 1) {
            this._nwQuadTree.clear();
            this._neQuadTree.clear();
            this._swQuadTree.clear();
            this._seQuadTree.clear();
        }
    }

    public int getMaxTreeDepth() {
        return this._nMaxTreeDepth;
    }

    public FigureEnumeration getAllWithin(Rectangle2D r) {
        List l = CollectionsFactory.current().createList();
        Iterator ii = this._outsideHashtable.keySet().iterator();
        while (ii.hasNext()) {
            Object anObject = ii.next();
            Rectangle2D itsAbsoluteBoundingRectangle2D = (Rectangle2D)this._outsideHashtable.get(anObject);
            if (!itsAbsoluteBoundingRectangle2D.intersects(r)) continue;
            l.add(anObject);
        }
        if (this._absoluteBoundingRectangle2D.intersects(r)) {
            Iterator i = this._theHashtable.keySet().iterator();
            while (i.hasNext()) {
                Object anObject = i.next();
                Rectangle2D itsAbsoluteBoundingRectangle2D = (Rectangle2D)this._theHashtable.get(anObject);
                if (!itsAbsoluteBoundingRectangle2D.intersects(r)) continue;
                l.add(anObject);
            }
            if (this._nMaxTreeDepth > 1) {
                l.add(this._nwQuadTree.getAllWithin(r));
                l.add(this._neQuadTree.getAllWithin(r));
                l.add(this._swQuadTree.getAllWithin(r));
                l.add(this._seQuadTree.getAllWithin(r));
            }
        }
        return new FigureEnumerator(l);
    }

    public Rectangle2D getAbsoluteBoundingRectangle2D() {
        return this._absoluteBoundingRectangle2D;
    }

    private void _init(int nMaxTreeDepth, Rectangle2D absoluteBoundingRectangle2D) {
        this._absoluteBoundingRectangle2D.setRect(absoluteBoundingRectangle2D);
        this._nMaxTreeDepth = nMaxTreeDepth;
        if (this._nMaxTreeDepth > 1) {
            this._nwQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeNorthwest(absoluteBoundingRectangle2D));
            this._neQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeNortheast(absoluteBoundingRectangle2D));
            this._swQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeSouthwest(absoluteBoundingRectangle2D));
            this._seQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeSoutheast(absoluteBoundingRectangle2D));
        }
    }

    private Rectangle2D _makeNorthwest(Rectangle2D r) {
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth() / 2.0, r.getHeight() / 2.0);
    }

    private Rectangle2D _makeNortheast(Rectangle2D r) {
        return new Rectangle2D.Double(r.getX() + r.getWidth() / 2.0, r.getY(), r.getWidth() / 2.0, r.getHeight() / 2.0);
    }

    private Rectangle2D _makeSouthwest(Rectangle2D r) {
        return new Rectangle2D.Double(r.getX(), r.getY() + r.getHeight() / 2.0, r.getWidth() / 2.0, r.getHeight() / 2.0);
    }

    private Rectangle2D _makeSoutheast(Rectangle2D r) {
        return new Rectangle2D.Double(r.getX() + r.getWidth() / 2.0, r.getY() + r.getHeight() / 2.0, r.getWidth() / 2.0, r.getHeight() / 2.0);
    }
}

