/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class RelativeLocator
extends AbstractLocator {
    private static final long serialVersionUID = 2619148876087898602L;
    private int relativeLocatorSerializedDataVersion = 1;
    double fRelativeX;
    double fRelativeY;
    static /* synthetic */ Class class$CH$ifa$draw$standard$RelativeLocator;

    public RelativeLocator() {
        this.fRelativeX = 0.0;
        this.fRelativeY = 0.0;
    }

    public boolean equals(Object o) {
        if ((class$CH$ifa$draw$standard$RelativeLocator == null ? (class$CH$ifa$draw$standard$RelativeLocator = RelativeLocator.class$("CH.ifa.draw.standard.RelativeLocator")) : class$CH$ifa$draw$standard$RelativeLocator).isInstance(o)) {
            RelativeLocator rl = (RelativeLocator)o;
            if (rl.fRelativeX == this.fRelativeX && rl.fRelativeY == this.fRelativeY) {
                return true;
            }
        }
        return false;
    }

    public RelativeLocator(double relativeX, double relativeY) {
        this.fRelativeX = relativeX;
        this.fRelativeY = relativeY;
    }

    public Point locate(Figure owner) {
        Rectangle r = owner.displayBox();
        return new Point(r.x + (int)((double)r.width * this.fRelativeX), r.y + (int)((double)r.height * this.fRelativeY));
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeDouble(this.fRelativeX);
        dw.writeDouble(this.fRelativeY);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fRelativeX = dr.readDouble();
        this.fRelativeY = dr.readDouble();
    }

    public static Locator east() {
        return new RelativeLocator(1.0, 0.5);
    }

    public static Locator north() {
        return new RelativeLocator(0.5, 0.0);
    }

    public static Locator west() {
        return new RelativeLocator(0.0, 0.5);
    }

    public static Locator northEast() {
        return new RelativeLocator(1.0, 0.0);
    }

    public static Locator northWest() {
        return new RelativeLocator(0.0, 0.0);
    }

    public static Locator south() {
        return new RelativeLocator(0.5, 1.0);
    }

    public static Locator southEast() {
        return new RelativeLocator(1.0, 1.0);
    }

    public static Locator southWest() {
        return new RelativeLocator(0.0, 1.0);
    }

    public static Locator center() {
        return new RelativeLocator(0.5, 0.5);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

