/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.HandleEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.HandleEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.CollectionsFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    private transient List fListeners = CollectionsFactory.current().createList(2);
    private transient Thread fDrawingLockHolder = null;
    private String myTitle;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    public StandardDrawing() {
        this.init(new Rectangle(-500, -500, 2000, 2000));
    }

    public void addDrawingChangeListener(DrawingChangeListener listener) {
        if (this.fListeners == null) {
            this.fListeners = CollectionsFactory.current().createList(2);
        }
        this.fListeners.add(listener);
    }

    public void removeDrawingChangeListener(DrawingChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public Iterator drawingChangeListeners() {
        return this.fListeners.iterator();
    }

    public synchronized Figure orphan(Figure figure) {
        Figure orphanedFigure = super.orphan(figure);
        if (orphanedFigure.listener() != null) {
            Rectangle rect = this.invalidateRectangle(this.displayBox());
            orphanedFigure.listener().figureRequestRemove(new FigureChangeEvent(orphanedFigure, rect));
        }
        return orphanedFigure;
    }

    public synchronized Figure add(Figure figure) {
        Figure addedFigure = super.add(figure);
        if (addedFigure.listener() != null) {
            Rectangle rect = this.invalidateRectangle(this.displayBox());
            addedFigure.listener().figureRequestUpdate(new FigureChangeEvent(figure, rect));
            return addedFigure;
        }
        return addedFigure;
    }

    public void figureInvalidated(FigureChangeEvent e) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                DrawingChangeListener l = (DrawingChangeListener)this.fListeners.get(i);
                l.drawingInvalidated(new DrawingChangeEvent(this, e.getInvalidatedRectangle()));
                ++i;
            }
        }
    }

    public void fireDrawingTitleChanged() {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                DrawingChangeListener l = (DrawingChangeListener)this.fListeners.get(i);
                l.drawingTitleChanged(new DrawingChangeEvent(this, null));
                ++i;
            }
        }
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                DrawingChangeListener l = (DrawingChangeListener)this.fListeners.get(i);
                l.drawingRequestUpdate(new DrawingChangeEvent(this, null));
                ++i;
            }
        }
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        handles.add(new NullHandle(this, RelativeLocator.northWest()));
        handles.add(new NullHandle(this, RelativeLocator.northEast()));
        handles.add(new NullHandle(this, RelativeLocator.southWest()));
        handles.add(new NullHandle(this, RelativeLocator.southEast()));
        return new HandleEnumerator(handles);
    }

    public Rectangle displayBox() {
        if (this.fFigures.size() > 0) {
            FigureEnumeration fe = this.figures();
            Rectangle r = fe.nextFigure().displayBox();
            while (fe.hasNextFigure()) {
                r.add(fe.nextFigure().displayBox());
            }
            return r;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void basicDisplayBox(Point p1, Point p2) {
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void lock() {
        current = Thread.currentThread();
        if (this.fDrawingLockHolder != current) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
lbl9:
            // 3 sources

            ** while (this.fDrawingLockHolder != null)
        }
lbl10:
        // 1 sources

        this.fDrawingLockHolder = current;
    }

    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notify();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fListeners = CollectionsFactory.current().createList(2);
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String newTitle) {
        this.myTitle = newTitle;
    }
}

