/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.JHotDrawRuntimeException;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ToolListener;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteIcon;
import CH.ifa.draw.util.PaletteListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.EventObject;
import javax.swing.ImageIcon;

public class ToolButton
extends PaletteButton
implements ToolListener {
    private Tool myTool;
    private PaletteIcon myIcon;

    public ToolButton(PaletteListener listener, String iconName, String name, Tool tool) {
        super(listener);
        tool.addToolListener(this);
        this.setEnabled(tool.isUsable());
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image[] im = new Image[]{kit.loadImageResource(iconName + "1.gif"), kit.loadImageResource(iconName + "2.gif"), kit.loadImageResource(iconName + "3.gif")};
        MediaTracker tracker = new MediaTracker(this);
        int i = 0;
        while (i < 3) {
            tracker.addImage(im[i], i);
            ++i;
        }
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setPaletteIcon(new PaletteIcon(new Dimension(24, 24), im[0], im[1], im[2]));
        this.setTool(tool);
        this.setName(name);
        if (im[0] != null) {
            this.setIcon(new ImageIcon(im[0]));
        }
        if (im[1] != null) {
            this.setPressedIcon(new ImageIcon(im[1]));
        }
        if (im[2] != null) {
            this.setSelectedIcon(new ImageIcon(im[2]));
        }
        this.setToolTipText(name);
    }

    public Tool tool() {
        return this.myTool;
    }

    public String name() {
        return this.getName();
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public void paintSelected(Graphics g) {
        if (this.getPaletteIcon().selected() != null) {
            g.drawImage(this.getPaletteIcon().selected(), 0, 0, this);
        }
    }

    public void paint(Graphics g) {
        if (this.isSelected()) {
            this.paintSelected(g);
        } else {
            super.paint(g);
        }
    }

    public void toolUsable(EventObject toolEvent) {
        this.setEnabled(true);
    }

    public void toolUnusable(EventObject toolEvent) {
        this.setEnabled(false);
        this.setSelected(false);
    }

    public void toolActivated(EventObject toolEvent) {
    }

    public void toolDeactivated(EventObject toolEvent) {
    }

    public void toolEnabled(EventObject toolEvent) {
        this.setEnabled(true);
    }

    public void toolDisabled(EventObject toolEvent) {
        this.setEnabled(false);
    }

    protected PaletteIcon getPaletteIcon() {
        return this.myIcon;
    }

    private void setPaletteIcon(PaletteIcon myIcon) {
        this.myIcon = myIcon;
    }

    private void setTool(Tool myTool) {
        this.myTool = myTool;
    }
}

