/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.List;

public class StorableInput {
    private StreamTokenizer fTokenizer;
    private List fMap;

    public StorableInput(InputStream stream) {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        this.fTokenizer = new StreamTokenizer(r);
        this.fTokenizer.wordChars(36, 36);
        this.fMap = CollectionsFactory.current().createList();
    }

    public Storable readStorable() throws IOException {
        String s = this.readString();
        if (s.equals("NULL")) {
            return null;
        }
        if (s.equals("REF")) {
            int ref = this.readInt();
            return this.retrieve(ref);
        }
        Storable storable = (Storable)this.makeInstance(s);
        this.map(storable);
        storable.read(this);
        return storable;
    }

    public String readString() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -3 || token == 34) {
            return this.fTokenizer.sval;
        }
        String msg = "String expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public int readInt() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        IOException exception = new IOException(msg);
        exception.printStackTrace();
        throw new IOException(msg);
    }

    public long readLong() throws IOException {
        long token = this.fTokenizer.nextToken();
        if (token == -2L) {
            return (long)this.fTokenizer.nval;
        }
        String msg = "Long expected in line: " + this.fTokenizer.lineno();
        IOException exception = new IOException(msg);
        throw exception;
    }

    public Color readColor() throws IOException {
        return new Color(this.readInt(), this.readInt(), this.readInt());
    }

    public double readDouble() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return this.fTokenizer.nval;
        }
        String msg = "Double expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    public boolean readBoolean() throws IOException {
        int token = this.fTokenizer.nextToken();
        if (token == -2) {
            return (int)this.fTokenizer.nval == 1;
        }
        String msg = "Integer expected in line: " + this.fTokenizer.lineno();
        throw new IOException(msg);
    }

    private Object makeInstance(String className) throws IOException {
        try {
            Class<?> cl = Class.forName(className);
            return cl.newInstance();
        }
        catch (NoSuchMethodError e) {
            throw new IOException("Class " + className + " does not seem to have a no-arg constructor");
        }
        catch (ClassNotFoundException e) {
            throw new IOException("No class: " + className);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate: " + className);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Class (" + className + ") not accessible");
        }
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.add(storable);
        }
    }

    private Storable retrieve(int ref) {
        return (Storable)this.fMap.get(ref);
    }
}

