/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class StorableOutput {
    private PrintWriter fStream;
    private List fMap;
    private int fIndent;

    public StorableOutput(OutputStream stream) {
        this.fStream = new PrintWriter(stream);
        this.fMap = CollectionsFactory.current().createList();
        this.fIndent = 0;
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print(storable.getClass().getName());
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeInt(int i) {
        this.fStream.print(i);
        this.space();
    }

    public void writeLong(long l) {
        this.fStream.print(l);
        this.space();
    }

    public void writeColor(Color c) {
        this.writeInt(c.getRed());
        this.writeInt(c.getGreen());
        this.writeInt(c.getBlue());
    }

    public void writeDouble(double d) {
        this.fStream.print(d);
        this.space();
    }

    public void writeBoolean(boolean b) {
        if (b) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeString(String s) {
        this.fStream.print('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    this.fStream.print('\\');
                    this.fStream.print('n');
                    break;
                }
                case '\"': {
                    this.fStream.print('\\');
                    this.fStream.print('\"');
                    break;
                }
                case '\\': {
                    this.fStream.print('\\');
                    this.fStream.print('\\');
                    break;
                }
                case '\t': {
                    this.fStream.print('\\');
                    this.fStream.print('\t');
                    break;
                }
                default: {
                    this.fStream.print(c);
                }
            }
            ++i;
        }
        this.fStream.print('\"');
        this.space();
    }

    public void close() {
        this.fStream.close();
    }

    private boolean mapped(Storable storable) {
        return this.fMap.contains(storable);
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.add(storable);
        }
    }

    private void writeRef(Storable storable) {
        int ref = this.fMap.indexOf(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(ref);
        this.space();
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void startNewLine() {
        this.fStream.println();
        int i = 0;
        while (i < this.fIndent) {
            this.space();
            ++i;
        }
    }

    private void space() {
        this.fStream.print(' ');
    }
}

