/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.CollectionsFactory;
import CH.ifa.draw.util.Undoable;
import java.util.Iterator;
import java.util.List;

public class UndoManager {
    public static final int DEFAULT_BUFFER_SIZE = 20;
    private List redoStack;
    private List undoStack;
    private int maxStackCapacity;

    public UndoManager() {
        this(20);
    }

    public UndoManager(int newUndoStackSize) {
        this.maxStackCapacity = newUndoStackSize;
        this.undoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        this.redoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
    }

    public void pushUndo(Undoable undoActivity) {
        if (undoActivity.isUndoable()) {
            this.removeFirstElementInFullList(this.undoStack);
            this.undoStack.add(undoActivity);
        } else {
            this.undoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        }
    }

    public void pushRedo(Undoable redoActivity) {
        if (redoActivity.isRedoable()) {
            this.removeFirstElementInFullList(this.redoStack);
            if (this.getRedoSize() == 0 || this.peekRedo() != redoActivity) {
                this.redoStack.add(redoActivity);
            }
        } else {
            this.redoStack = CollectionsFactory.current().createList(this.maxStackCapacity);
        }
    }

    private void removeFirstElementInFullList(List l) {
        if (l.size() >= this.maxStackCapacity) {
            Undoable removedActivity = (Undoable)l.remove(0);
            removedActivity.release();
        }
    }

    private Undoable getLastElement(List l) {
        if (l.size() > 0) {
            return (Undoable)l.get(l.size() - 1);
        }
        return null;
    }

    public boolean isUndoable() {
        if (this.getUndoSize() > 0) {
            return this.getLastElement(this.undoStack).isUndoable();
        }
        return false;
    }

    public boolean isRedoable() {
        if (this.getRedoSize() > 0) {
            return this.getLastElement(this.redoStack).isRedoable();
        }
        return false;
    }

    protected Undoable peekUndo() {
        if (this.getUndoSize() > 0) {
            return this.getLastElement(this.undoStack);
        }
        return null;
    }

    protected Undoable peekRedo() {
        if (this.getRedoSize() > 0) {
            return this.getLastElement(this.redoStack);
        }
        return null;
    }

    public int getUndoSize() {
        return this.undoStack.size();
    }

    public int getRedoSize() {
        return this.redoStack.size();
    }

    public Undoable popUndo() {
        Undoable lastUndoable = this.peekUndo();
        this.undoStack.remove(this.getUndoSize() - 1);
        return lastUndoable;
    }

    public Undoable popRedo() {
        Undoable lastUndoable = this.peekRedo();
        this.redoStack.remove(this.getRedoSize() - 1);
        return lastUndoable;
    }

    public void clearUndos() {
        this.clearStack(this.undoStack);
    }

    public void clearRedos() {
        this.clearStack(this.redoStack);
    }

    protected void clearStack(List clearStack) {
        clearStack.clear();
    }

    public void clearUndos(DrawingView checkDV) {
        Iterator iter = this.undoStack.iterator();
        while (iter.hasNext()) {
            Undoable currentUndo = (Undoable)iter.next();
            if (currentUndo.getDrawingView() != checkDV) continue;
            iter.remove();
        }
    }

    public void clearRedos(DrawingView checkDV) {
        Iterator iter = this.redoStack.iterator();
        while (iter.hasNext()) {
            Undoable currentRedo = (Undoable)iter.next();
            if (currentRedo.getDrawingView() != checkDV) continue;
            iter.remove();
        }
    }
}

