/*
 * Decompiled with CFR 0.152.
 */
package jax;

import jax.AgentXPDU;

public class AgentXClosePDU
extends AgentXPDU {
    private int cReason;
    public static final int OTHER = 1;
    public static final int PARSE_ERROR = 2;
    public static final int PROTOCOL_ERROR = 3;
    public static final int TIMEOUTS = 4;
    public static final int SHUTDOWN = 5;
    public static final int BY_MANAGER = 6;

    public AgentXClosePDU() {
        this.setType(2);
        this.setPayloadLength(4L);
    }

    byte[] getCloseBytes() {
        byte[] byArray = new byte[]{(byte)this.cReason, 0, 0, 0};
        return byArray;
    }

    private String toCloseString() {
        return "ClosePDU--------------------------------------------------\nReason: " + this.getReasonString() + "\n" + "--------------------------------------------------ClosePDU\n";
    }

    public byte[] getBytes() {
        byte[] byArray = this.joinBytes(this.getHeaderBytes(), this.getCloseBytes());
        return byArray;
    }

    public String toString() {
        return this.toHeaderString() + this.toCloseString();
    }

    public void setReason(int n) throws ClassCastException {
        if (n > 256) {
            throw new ClassCastException();
        }
        this.cReason = n;
    }

    public int getReason() {
        return this.cReason;
    }

    public String getReasonString() {
        switch (this.cReason) {
            case 1: {
                return "not specified";
            }
            case 2: {
                return "parse error";
            }
            case 3: {
                return "protocol error";
            }
            case 4: {
                return "too many timeouts";
            }
            case 5: {
                return "shutdown";
            }
            case 6: {
                return "manager closed the session";
            }
        }
        return "invalid reason";
    }

    public void setNonDefaultContext(boolean bl) {
    }

    public void setContext(String string) {
    }
}

