/*
 * Decompiled with CFR 0.152.
 */
package jax;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import jax.AgentXClosePDU;
import jax.AgentXDebug;
import jax.AgentXOpenPDU;
import jax.AgentXPDU;
import jax.AgentXReader;
import jax.AgentXSession;
import jax.AgentXSignal;

public class AgentXConnection {
    private Vector sessions = new Vector();
    protected Socket socket;
    private AgentXReader reader = null;
    protected boolean open = false;
    private static final int AGENTX_TCP_PORT = 705;
    private AgentXPDU receivedPDU;

    public AgentXConnection() throws UnknownHostException, IOException {
        this.open(InetAddress.getByName("localhost"), 705, null);
    }

    public AgentXConnection(String string, int n) throws UnknownHostException, IOException {
        this.open(InetAddress.getByName(string), n, null);
    }

    public AgentXConnection(String string) throws UnknownHostException, IOException {
        this.open(InetAddress.getByName(string), 705, null);
    }

    public AgentXConnection(InetAddress inetAddress, int n, AgentXSignal agentXSignal) throws UnknownHostException, IOException {
        this.open(inetAddress, n, agentXSignal);
    }

    public AgentXConnection(InetAddress inetAddress) throws UnknownHostException, IOException {
        this.open(inetAddress, 705, null);
    }

    private void open(InetAddress inetAddress, int n, AgentXSignal agentXSignal) throws IOException {
        this.socket = new Socket(inetAddress, n);
        this.reader = new AgentXReader(this, agentXSignal);
        this.open = true;
        this.reader.start();
    }

    public void close() throws IOException, InterruptedException {
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            AgentXSession agentXSession = (AgentXSession)enumeration.nextElement();
            agentXSession.close((short)5);
        }
        this.sessions = null;
        this.open = false;
        this.socket.close();
    }

    public synchronized void openSession(AgentXSession agentXSession) throws InterruptedException, IOException {
        this.sessions.addElement(agentXSession);
        agentXSession.setConnection(this);
        AgentXOpenPDU agentXOpenPDU = new AgentXOpenPDU();
        agentXOpenPDU.setTimeout(agentXSession.getTimeout());
        agentXOpenPDU.setNetworkByteOrder(true);
        agentXOpenPDU.setOID(agentXSession.getOID());
        agentXOpenPDU.setDescription("Knock, Knock, Neo!");
        AgentXConnection agentXConnection = this;
        synchronized (agentXConnection) {
            this.send(agentXOpenPDU);
            AgentXDebug.debugMessage("waiting for open response");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                AgentXDebug.debugMessage("interrupted wait: " + interruptedException);
                throw interruptedException;
            }
        }
        AgentXDebug.debugMessage("got response, session opened");
    }

    public synchronized void closeSession(AgentXSession agentXSession, short s) throws InterruptedException, IOException {
        AgentXClosePDU agentXClosePDU = new AgentXClosePDU();
        agentXClosePDU.setNetworkByteOrder(true);
        agentXClosePDU.setReason(s);
        AgentXConnection agentXConnection = this;
        synchronized (agentXConnection) {
            this.send(agentXClosePDU);
            AgentXDebug.debugMessage("waiting for close response");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                AgentXDebug.debugMessage("interrupted wait: " + interruptedException);
                throw interruptedException;
            }
            this.sessions.removeElement(agentXSession);
            agentXSession = null;
        }
        AgentXDebug.debugMessage("got response, session closed");
    }

    public AgentXSession getSession(long l) {
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            AgentXSession agentXSession = (AgentXSession)enumeration.nextElement();
            if (agentXSession.getSessionID() != l) continue;
            return agentXSession;
        }
        return null;
    }

    public void send(AgentXPDU agentXPDU) throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(agentXPDU.getBytes());
        AgentXDebug.debugMessage("PDU sent");
        AgentXDebug.debugPdu(agentXPDU);
    }

    public void setReceivedPDU(AgentXPDU agentXPDU) {
        this.receivedPDU = agentXPDU;
    }

    public AgentXPDU getReceivedPDU() {
        return this.receivedPDU;
    }
}

