/*
 * Decompiled with CFR 0.152.
 */
package jax;

import java.util.Enumeration;
import java.util.Vector;
import jax.AgentXOID;
import jax.AgentXVarBind;

public class AgentXPDU {
    private byte hVersion = 1;
    private byte hType = (byte)13;
    private boolean hInstReg;
    private boolean hNewIndex;
    private boolean hAnyIndex;
    private boolean hNonDefaultContext = false;
    private boolean hNetworkByteOrder = false;
    private long hPayloadLength = 0L;
    private long hSessionID;
    private long hTransactionID;
    private long hPacketID;
    private String hContext = "default";
    boolean updatePayloadLength = true;
    private byte[] fakeMem = null;
    public static final int OPEN_PDU = 1;
    public static final int CLOSE_PDU = 2;
    public static final int REGISTER_PDU = 3;
    public static final int UNREGISTER_PDU = 4;
    public static final int GET_PDU = 5;
    public static final int GET_NEXT_PDU = 6;
    public static final int GET_BULK_PDU = 7;
    public static final int TEST_SET_PDU = 8;
    public static final int COMMIT_SET_PDU = 9;
    public static final int UNDO_SET_PDU = 10;
    public static final int CLEAN_UP_SET_PDU = 11;
    public static final int NOTIFY_PDU = 12;
    public static final int PING_PDU = 13;
    public static final int INDEX_ALLOCATE_PDU = 14;
    public static final int INDEX_DEALLOCATE_PDU = 15;
    public static final int ADD_AGENT_CAPS_PDU = 16;
    public static final int REMOVE_AGENT_CAPS_PDU = 17;
    public static final int RESPONSE_PDU = 18;

    byte[] toVarbindBytes(Vector vector) {
        Enumeration enumeration = vector.elements();
        AgentXVarBind agentXVarBind = null;
        byte[] byArray = new byte[]{};
        while (enumeration.hasMoreElements()) {
            agentXVarBind = (AgentXVarBind)enumeration.nextElement();
            byArray = this.joinBytes(byArray, this.get16Bit(agentXVarBind.getValueType()));
            byArray = this.joinBytes(byArray, this.get16Bit(0));
            byArray = this.joinBytes(byArray, this.getOIDBytes(agentXVarBind.getOID()));
            switch (agentXVarBind.getValueType()) {
                case 2: 
                case 65: 
                case 66: 
                case 67: {
                    byArray = this.joinBytes(byArray, this.getIntBytes(agentXVarBind.longValue()));
                    break;
                }
                case 6: {
                    byArray = this.joinBytes(byArray, this.getOIDBytes(agentXVarBind.AgentXOIDValue()));
                    break;
                }
                case 4: 
                case 64: 
                case 68: {
                    byArray = this.joinBytes(byArray, this.getStringBytes(agentXVarBind.bytesValue()));
                    break;
                }
                case 70: {
                    byArray = this.joinBytes(byArray, this.getIntBytes(0L));
                    byArray = this.joinBytes(byArray, this.getIntBytes(agentXVarBind.longValue()));
                }
            }
        }
        return byArray;
    }

    private byte getNthByte(long l, int n) {
        if (this.hNetworkByteOrder) {
            n = 3 - n;
        }
        return (byte)((l >>= n * 8) % 256L);
    }

    byte[] getIntBytes(long l) {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[n] = this.getNthByte(l, n);
            ++n;
        }
        return byArray;
    }

    byte[] get16Bit(int n) {
        byte[] byArray = new byte[2];
        if (this.hNetworkByteOrder) {
            byArray[0] = (byte)(n / 256);
            byArray[1] = (byte)(n % 256);
        } else {
            byArray[1] = (byte)(n / 256);
            byArray[0] = (byte)(n % 256);
        }
        return byArray;
    }

    byte[] joinBytes(byte[] byArray, byte[] byArray2) {
        int n = 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        n = 0;
        while (n < byArray.length) {
            byArray3[n] = byArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray3[n + n2] = byArray2[n2];
            ++n2;
        }
        return byArray3;
    }

    byte[] getOIDBytes(AgentXOID agentXOID) {
        long[] lArray = agentXOID.getArray();
        byte[] byArray = new byte[(lArray.length + 1) * 4];
        byArray[0] = (byte)lArray.length;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        int n = 0;
        while (n < lArray.length) {
            int n2 = 0;
            while (n2 < 4) {
                byArray[4 * (n + 1) + n2] = this.getNthByte((int)lArray[n], n2);
                ++n2;
            }
            ++n;
        }
        return byArray;
    }

    byte[] getStringBytes(byte[] byArray) {
        int n = byArray.length + 4;
        if (n % 4 != 0) {
            n += 4 - n % 4;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < 4) {
            byArray2[n2] = this.getNthByte(byArray.length, n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[4 + n3] = byArray[n3];
            ++n3;
        }
        return byArray2;
    }

    byte[] getHeaderBytes() {
        int n = 20;
        if (this.hNonDefaultContext && (n = n + 4 + this.hContext.length()) % 4 != 0) {
            n += 4 - n % 4;
        }
        byte[] byArray = new byte[n];
        byArray[0] = this.hVersion;
        byArray[1] = this.hType;
        byArray[2] = 0;
        if (this.hInstReg) {
            byArray[2] = (byte)(byArray[2] + 1);
        }
        if (this.hNewIndex) {
            byArray[2] = (byte)(byArray[2] + 2);
        }
        if (this.hAnyIndex) {
            byArray[2] = (byte)(byArray[2] + 4);
        }
        if (this.hNonDefaultContext) {
            byArray[2] = (byte)(byArray[2] + 8);
        }
        if (this.hNetworkByteOrder) {
            byArray[2] = (byte)(byArray[2] + 16);
        }
        byArray[3] = 0;
        int n2 = 0;
        while (n2 < 4) {
            byArray[4 + n2] = this.getNthByte(this.hSessionID, n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 4) {
            byArray[8 + n3] = this.getNthByte(this.hTransactionID, n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < 4) {
            byArray[12 + n4] = this.getNthByte(this.hPacketID, n4);
            ++n4;
        }
        int n5 = 0;
        while (n5 < 4) {
            byArray[16 + n5] = this.getNthByte(this.hPayloadLength, n5);
            ++n5;
        }
        if (this.hNonDefaultContext) {
            int n6 = 0;
            while (n6 < 4) {
                byArray[20 + n6] = this.getNthByte(this.hContext.length(), n6);
                ++n6;
            }
            byte[] byArray2 = this.hContext.getBytes();
            int n7 = 0;
            while (n7 < this.hContext.length()) {
                byArray[24 + n7] = byArray2[n7];
                ++n7;
            }
        }
        return byArray;
    }

    String toHeaderString() {
        String string = "AgentXHeader----------------------------------------------\nAgentXVersion: " + this.hVersion + "\t PDUType: " + this.getTypeString() + "\nFlags : ";
        if (this.hInstReg) {
            string = string + " +InstReg ";
        }
        if (this.hNewIndex) {
            string = string + " +NewIndex ";
        }
        if (this.hAnyIndex) {
            string = string + " +AnyIndex ";
        }
        if (this.hNonDefaultContext) {
            string = string + " +NonDefaultContext ";
        }
        if (this.hNetworkByteOrder) {
            string = string + " +NetworkByteOrder ";
        }
        string = string + "\nSessionID = " + this.hSessionID + ", TransactionID = " + this.hTransactionID + ", PacketID = " + this.hPacketID + "\nPayload = " + this.hPayloadLength + " Octets \n";
        if (this.hNonDefaultContext) {
            string = string + "Context: " + this.hContext + "\n";
        }
        string = string + "----------------------------------------------AgentXHeader\n";
        return string;
    }

    public byte[] getBytes() {
        if (this.fakeMem != null) {
            this.setPayloadLength(this.fakeMem.length);
            return this.joinBytes(this.getHeaderBytes(), this.fakeMem);
        }
        return this.getHeaderBytes();
    }

    public String toString() {
        return this.toHeaderString();
    }

    public void setVersion(int n) {
    }

    public int getVersion() {
        return this.hVersion;
    }

    public void setType(int n) {
        this.hType = (byte)n;
    }

    public int getType() {
        return this.hType;
    }

    public void payloadAutoUpdate(boolean bl) {
        this.updatePayloadLength = bl;
    }

    public String getTypeString() {
        switch (this.hType) {
            case 1: {
                return "Open-PDU";
            }
            case 2: {
                return "Close-PDU";
            }
            case 3: {
                return "Register-PDU";
            }
            case 4: {
                return "Unregister-PDU";
            }
            case 5: {
                return "Get-PDU";
            }
            case 6: {
                return "GetNext-PDU";
            }
            case 7: {
                return "GetBulk-PDU";
            }
            case 8: {
                return "TestSet-PDU";
            }
            case 9: {
                return "CommitSet-PDU";
            }
            case 10: {
                return "UndoSet-PDU";
            }
            case 11: {
                return "CleanUpSet-PDU";
            }
            case 12: {
                return "Notify-PDU";
            }
            case 13: {
                return "Ping-PDU";
            }
            case 14: {
                return "IndexAllocate-PDU";
            }
            case 15: {
                return "IndexDeallocate-PDU";
            }
            case 16: {
                return "AddAgentCaps-PDU";
            }
            case 17: {
                return "RemoveAgentCaps-PDU";
            }
            case 18: {
                return "Response-PDU";
            }
        }
        return "Unknown PDU (" + this.hType + ")";
    }

    public void setInstanceReg(boolean bl) {
        this.hInstReg = bl;
    }

    public boolean getInstanceReg() {
        return this.hInstReg;
    }

    public void setNewIndex(boolean bl) {
        this.hNewIndex = bl;
    }

    public boolean getNewIndex() {
        return this.hNewIndex;
    }

    public boolean getAnyIndex() {
        return this.hAnyIndex;
    }

    public void setAnyIndex(boolean bl) {
        this.hAnyIndex = bl;
    }

    public void setNonDefaultContext(boolean bl) {
        this.hNonDefaultContext = bl;
    }

    public boolean getNonDefaultContext() {
        return this.hNonDefaultContext;
    }

    public boolean getNetworkByteOrder() {
        return this.hNetworkByteOrder;
    }

    public void setNetworkByteOrder(boolean bl) {
        this.hNetworkByteOrder = bl;
    }

    public void setPayloadLength(long l) {
        if (l % 4L != 0L) {
            l += 4L - l % 4L;
        }
        this.hPayloadLength = l;
    }

    public long getPayloadLength() {
        return this.hPayloadLength;
    }

    public void setSessionID(long l) {
        this.hSessionID = l;
    }

    public long getSessionID() {
        return this.hSessionID;
    }

    public void setTransactionID(long l) {
        this.hTransactionID = l;
    }

    public long getTransactionID() {
        return this.hTransactionID;
    }

    public void setPacketID(long l) {
        this.hPacketID = l;
    }

    public void fakeContent(byte[] byArray) {
        this.fakeMem = byArray;
    }

    public long getPacketID() {
        return this.hPacketID;
    }

    public String getContext() {
        return this.hContext;
    }

    public void updateStringPayload(String string, String string2) {
        long l = string.length() + 4;
        if (l % 4L != 0L) {
            l += 4L - l % 4L;
        }
        l = this.getPayloadLength() - l;
        this.setPayloadLength(l += (long)(string2.length() + 4));
    }

    public void setContext(String string) {
        long l;
        if (this.hNonDefaultContext) {
            l = this.hContext.length() + 4;
            if (l % 4L != 0L) {
                l += 4L - l % 4L;
            }
            l = this.getPayloadLength() - l;
        } else {
            l = this.getPayloadLength();
        }
        l += (long)(string.length() + 4);
        if (this.updatePayloadLength) {
            this.setPayloadLength(l);
        }
        this.hNonDefaultContext = true;
        this.hContext = string;
    }
}

