/*
 * Decompiled with CFR 0.152.
 */
package jax;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Vector;
import jax.AgentXAddAgentCapsPDU;
import jax.AgentXCleanUpSetPDU;
import jax.AgentXClosePDU;
import jax.AgentXCommitSetPDU;
import jax.AgentXConnection;
import jax.AgentXDebug;
import jax.AgentXGetBulkPDU;
import jax.AgentXGetNextPDU;
import jax.AgentXGetPDU;
import jax.AgentXIndexAllocatePDU;
import jax.AgentXIndexDeallocatePDU;
import jax.AgentXNotifyPDU;
import jax.AgentXOID;
import jax.AgentXOpenPDU;
import jax.AgentXPDU;
import jax.AgentXPingPDU;
import jax.AgentXRegisterPDU;
import jax.AgentXRemoveAgentCapsPDU;
import jax.AgentXResponsePDU;
import jax.AgentXSession;
import jax.AgentXSignal;
import jax.AgentXTestSetPDU;
import jax.AgentXUndoSetPDU;
import jax.AgentXUnregisterPDU;
import jax.AgentXVarBind;

public class AgentXReader
extends Thread {
    AgentXConnection connection;
    AgentXSignal signaller;

    public AgentXReader(AgentXConnection agentXConnection, AgentXSignal agentXSignal) {
        this.connection = agentXConnection;
        this.signaller = agentXSignal;
    }

    private static String parseDisplayString(int n, byte[] byArray, boolean bl) {
        int n2 = -1;
        n2 = (int)AgentXReader.parseInt(n, byArray, bl);
        String string = new String(byArray, n + 4, n2);
        return string;
    }

    private static int parseShort(int n, byte[] byArray, boolean bl) {
        int[] nArray = new int[]{0, 0};
        nArray[0] = byArray[n] >= 0 ? byArray[n] : 256 + byArray[n];
        nArray[1] = byArray[n + 1] >= 0 ? byArray[n + 1] : 256 + byArray[n + 1];
        return bl ? nArray[0] * 256 + nArray[1] : nArray[0] + nArray[1] * 256;
    }

    private static long parseInt(int n, byte[] byArray, boolean bl) {
        int n2 = 0;
        int n3 = n;
        while (n3 < n + 4) {
            int n4 = !bl ? 1 << (n3 - n) * 8 : 1 << -(1 + n3 - n) * 8;
            n2 += n4 * (byArray[n3] >= 0 ? byArray[n3] : 256 + byArray[n3]);
            ++n3;
        }
        return n2;
    }

    private static AgentXOID parseOID(int n, byte[] byArray, boolean bl) {
        long[] lArray;
        int n2 = byArray[n];
        int n3 = 0;
        if (n2 < 1) {
            AgentXDebug.debugMessage("Could not Parse OID using 0");
            return new AgentXOID();
        }
        if (byArray[n + 1] == 0) {
            lArray = new long[n2];
        } else {
            n3 = 5;
            lArray = new long[n2 + n3];
            lArray[0] = 1L;
            lArray[1] = 3L;
            lArray[2] = 6L;
            lArray[3] = 1L;
            lArray[4] = byArray[n + 1];
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray[n4 + n3] = AgentXReader.parseInt(n + (n4 + 1) * 4, byArray, bl);
            ++n4;
        }
        AgentXOID agentXOID = new AgentXOID(lArray);
        agentXOID.setInclude(byArray[n + 2] == 1);
        return agentXOID;
    }

    private static Vector parseVarBind(int n, long l, byte[] byArray, boolean bl) {
        Vector<AgentXVarBind> vector = new Vector<AgentXVarBind>();
        while ((long)n < l) {
            AgentXVarBind agentXVarBind = new AgentXVarBind();
            agentXVarBind.setValueType(AgentXReader.parseShort(n, byArray, bl));
            agentXVarBind.setOID(AgentXReader.parseOID(n + 4, byArray, bl));
            n += (byArray[n + 4] + 2) * 4;
            switch (agentXVarBind.getValueType()) {
                case 2: 
                case 65: 
                case 66: 
                case 67: {
                    agentXVarBind.setInt(AgentXReader.parseInt(n, byArray, bl));
                    n += 4;
                    vector.addElement(agentXVarBind);
                    break;
                }
                case 6: {
                    agentXVarBind.setAgentXOID(AgentXReader.parseOID(n, byArray, bl));
                    n += (byArray[n] + 1) * 4;
                    vector.addElement(agentXVarBind);
                    break;
                }
                case 4: 
                case 64: 
                case 68: {
                    agentXVarBind.setBytes(AgentXReader.parseDisplayString(n, byArray, bl).getBytes());
                    n = (int)((long)n + AgentXReader.parseInt(n, byArray, bl));
                    n += n % 4 == 0 ? 4 : 4 - n % 4 + 4;
                    vector.addElement(agentXVarBind);
                    break;
                }
                case 70: {
                    agentXVarBind.setInt(AgentXReader.parseInt(n + 4, byArray, bl));
                    n += 8;
                    vector.addElement(agentXVarBind);
                }
                case 5: 
                case 128: 
                case 129: 
                case 130: {
                    vector.addElement(agentXVarBind);
                }
                default: {
                    AgentXDebug.debugMessage("Invalid type for varbind:" + agentXVarBind.getValueType());
                }
            }
        }
        return vector;
    }

    private static int parseHeader(AgentXPDU agentXPDU, byte[] byArray) throws ParseException {
        agentXPDU.payloadAutoUpdate(false);
        agentXPDU.setVersion(byArray[0]);
        agentXPDU.setType(byArray[1]);
        agentXPDU.setInstanceReg((1 & byArray[2]) > 0);
        agentXPDU.setNewIndex((2 & byArray[2]) > 0);
        agentXPDU.setAnyIndex((4 & byArray[2]) > 0);
        agentXPDU.setNonDefaultContext((8 & byArray[2]) > 0);
        agentXPDU.setNetworkByteOrder((0x10 & byArray[2]) > 0);
        if (agentXPDU.getNonDefaultContext()) {
            agentXPDU.setContext(AgentXReader.parseDisplayString(16, byArray, agentXPDU.getNetworkByteOrder()));
        }
        agentXPDU.setSessionID(AgentXReader.parseInt(4, byArray, agentXPDU.getNetworkByteOrder()));
        agentXPDU.setTransactionID(AgentXReader.parseInt(8, byArray, agentXPDU.getNetworkByteOrder()));
        agentXPDU.setPacketID(AgentXReader.parseInt(12, byArray, agentXPDU.getNetworkByteOrder()));
        agentXPDU.setPayloadLength(AgentXReader.parseInt(16, byArray, agentXPDU.getNetworkByteOrder()));
        if (agentXPDU.getNonDefaultContext()) {
            return 24 + agentXPDU.getContext().length();
        }
        return 20;
    }

    private static AgentXPDU parseOpenPDU(byte[] byArray) throws ParseException {
        AgentXOpenPDU agentXOpenPDU = new AgentXOpenPDU();
        int n = AgentXReader.parseHeader(agentXOpenPDU, byArray);
        agentXOpenPDU.setTimeout(byArray[n]);
        agentXOpenPDU.setOID(AgentXReader.parseOID(n += 4, byArray, agentXOpenPDU.getNetworkByteOrder()));
        n += (byArray[n] + 1) * 4;
        agentXOpenPDU.setDescription(AgentXReader.parseDisplayString(n, byArray, agentXOpenPDU.getNetworkByteOrder()));
        return agentXOpenPDU;
    }

    private static AgentXPDU parseClosePDU(byte[] byArray) throws ParseException {
        AgentXClosePDU agentXClosePDU = new AgentXClosePDU();
        int n = AgentXReader.parseHeader(agentXClosePDU, byArray);
        agentXClosePDU.setReason(byArray[n]);
        return agentXClosePDU;
    }

    private static AgentXPDU parseRegisterPDU(byte[] byArray) throws ParseException {
        AgentXRegisterPDU agentXRegisterPDU = new AgentXRegisterPDU();
        int n = 0;
        int n2 = AgentXReader.parseHeader(agentXRegisterPDU, byArray);
        agentXRegisterPDU.setTimeout(byArray[n2]);
        agentXRegisterPDU.setPriority(byArray[n2 + 1]);
        n = byArray[n2 + 3];
        if (byArray[n2 + 4] != 0 && n != 0) {
            n += 5;
        }
        agentXRegisterPDU.setRangeSubID(n);
        agentXRegisterPDU.setSubtree(AgentXReader.parseOID(n2 + 4, byArray, agentXRegisterPDU.getNetworkByteOrder()));
        n2 += byArray[n2 + 4] * 4;
        agentXRegisterPDU.setUpperBound(AgentXReader.parseInt(n2, byArray, agentXRegisterPDU.getNetworkByteOrder()));
        return agentXRegisterPDU;
    }

    private static AgentXPDU parseUnregisterPDU(byte[] byArray) throws ParseException {
        AgentXUnregisterPDU agentXUnregisterPDU = new AgentXUnregisterPDU();
        int n = 0;
        int n2 = AgentXReader.parseHeader(agentXUnregisterPDU, byArray);
        agentXUnregisterPDU.setPriority(byArray[n2 + 1]);
        n = byArray[n2 + 3];
        if (byArray[n2 + 4] != 0 && n != 0) {
            n += 5;
        }
        agentXUnregisterPDU.setRangeSubID(n);
        agentXUnregisterPDU.setSubtree(AgentXReader.parseOID(n2 + 4, byArray, agentXUnregisterPDU.getNetworkByteOrder()));
        n2 += (byArray[n2 + 4] + 2) * 4;
        agentXUnregisterPDU.setUpperBound(AgentXReader.parseInt(n2, byArray, agentXUnregisterPDU.getNetworkByteOrder()));
        return agentXUnregisterPDU;
    }

    private static AgentXPDU parseGetPDU(byte[] byArray) throws ParseException {
        AgentXGetPDU agentXGetPDU = new AgentXGetPDU();
        boolean bl = false;
        int n = AgentXReader.parseHeader(agentXGetPDU, byArray);
        while ((long)n < agentXGetPDU.getPayloadLength()) {
            agentXGetPDU.addOID(AgentXReader.parseOID(n, byArray, agentXGetPDU.getNetworkByteOrder()));
            n += (byArray[n] + 2) * 4;
        }
        return agentXGetPDU;
    }

    private static AgentXPDU parseGetNextPDU(byte[] byArray) throws ParseException {
        AgentXGetNextPDU agentXGetNextPDU = new AgentXGetNextPDU();
        boolean bl = false;
        int n = AgentXReader.parseHeader(agentXGetNextPDU, byArray);
        while ((long)n < agentXGetNextPDU.getPayloadLength()) {
            AgentXOID agentXOID = AgentXReader.parseOID(n, byArray, agentXGetNextPDU.getNetworkByteOrder());
            n += (byArray[n] + 1) * 4;
            AgentXOID agentXOID2 = AgentXReader.parseOID(n, byArray, agentXGetNextPDU.getNetworkByteOrder());
            n += (byArray[n] + 1) * 4;
            agentXGetNextPDU.addOIDs(agentXOID, agentXOID2);
        }
        return agentXGetNextPDU;
    }

    private static AgentXPDU parseGetBulkPDU(byte[] byArray) throws ParseException {
        AgentXGetBulkPDU agentXGetBulkPDU = new AgentXGetBulkPDU();
        int n = AgentXReader.parseHeader(agentXGetBulkPDU, byArray);
        return agentXGetBulkPDU;
    }

    private static AgentXPDU parseTestSetPDU(byte[] byArray) throws ParseException {
        AgentXTestSetPDU agentXTestSetPDU = new AgentXTestSetPDU();
        int n = AgentXReader.parseHeader(agentXTestSetPDU, byArray);
        if (agentXTestSetPDU.getPayloadLength() > 0L) {
            Vector vector = AgentXReader.parseVarBind(n, agentXTestSetPDU.getPayloadLength(), byArray, agentXTestSetPDU.getNetworkByteOrder());
            agentXTestSetPDU.setVarBindList(vector);
        }
        return agentXTestSetPDU;
    }

    private static AgentXPDU parseCommitSetPDU(byte[] byArray) throws ParseException {
        AgentXCommitSetPDU agentXCommitSetPDU = new AgentXCommitSetPDU();
        int n = AgentXReader.parseHeader(agentXCommitSetPDU, byArray);
        return agentXCommitSetPDU;
    }

    private static AgentXPDU parseUndoSetPDU(byte[] byArray) throws ParseException {
        AgentXUndoSetPDU agentXUndoSetPDU = new AgentXUndoSetPDU();
        int n = AgentXReader.parseHeader(agentXUndoSetPDU, byArray);
        return agentXUndoSetPDU;
    }

    private static AgentXPDU parseCleanUpSetPDU(byte[] byArray) throws ParseException {
        AgentXCleanUpSetPDU agentXCleanUpSetPDU = new AgentXCleanUpSetPDU();
        int n = AgentXReader.parseHeader(agentXCleanUpSetPDU, byArray);
        return agentXCleanUpSetPDU;
    }

    private static AgentXPDU parseNotifyPDU(byte[] byArray) throws ParseException {
        AgentXNotifyPDU agentXNotifyPDU = new AgentXNotifyPDU();
        int n = AgentXReader.parseHeader(agentXNotifyPDU, byArray);
        if (agentXNotifyPDU.getPayloadLength() > (long)(agentXNotifyPDU.getContext().length() + 4)) {
            Vector vector = AgentXReader.parseVarBind(n, agentXNotifyPDU.getPayloadLength(), byArray, agentXNotifyPDU.getNetworkByteOrder());
            agentXNotifyPDU.setVarBindList(vector);
        }
        return agentXNotifyPDU;
    }

    private static AgentXPDU parsePingPDU(byte[] byArray) throws ParseException {
        AgentXPingPDU agentXPingPDU = new AgentXPingPDU();
        int n = AgentXReader.parseHeader(agentXPingPDU, byArray);
        return agentXPingPDU;
    }

    private static AgentXPDU parseIndexAllocatePDU(byte[] byArray) throws ParseException {
        AgentXIndexAllocatePDU agentXIndexAllocatePDU = new AgentXIndexAllocatePDU();
        int n = AgentXReader.parseHeader(agentXIndexAllocatePDU, byArray);
        if (agentXIndexAllocatePDU.getPayloadLength() > (long)(agentXIndexAllocatePDU.getContext().length() + 4)) {
            Vector vector = AgentXReader.parseVarBind(n, agentXIndexAllocatePDU.getPayloadLength(), byArray, agentXIndexAllocatePDU.getNetworkByteOrder());
            agentXIndexAllocatePDU.setVarBindList(vector);
        }
        return agentXIndexAllocatePDU;
    }

    private static AgentXPDU parseIndexDeallocatePDU(byte[] byArray) throws ParseException {
        AgentXIndexDeallocatePDU agentXIndexDeallocatePDU = new AgentXIndexDeallocatePDU();
        int n = AgentXReader.parseHeader(agentXIndexDeallocatePDU, byArray);
        if (agentXIndexDeallocatePDU.getPayloadLength() > (long)(agentXIndexDeallocatePDU.getContext().length() + 4)) {
            Vector vector = AgentXReader.parseVarBind(n, agentXIndexDeallocatePDU.getPayloadLength(), byArray, agentXIndexDeallocatePDU.getNetworkByteOrder());
            agentXIndexDeallocatePDU.setVarBindList(vector);
        }
        return agentXIndexDeallocatePDU;
    }

    private static AgentXPDU parseAddAgentCapsPDU(byte[] byArray) throws ParseException {
        AgentXAddAgentCapsPDU agentXAddAgentCapsPDU = new AgentXAddAgentCapsPDU();
        int n = AgentXReader.parseHeader(agentXAddAgentCapsPDU, byArray);
        return agentXAddAgentCapsPDU;
    }

    private static AgentXPDU parseRemoveAgentCapsPDU(byte[] byArray) throws ParseException {
        AgentXRemoveAgentCapsPDU agentXRemoveAgentCapsPDU = new AgentXRemoveAgentCapsPDU();
        int n = AgentXReader.parseHeader(agentXRemoveAgentCapsPDU, byArray);
        return agentXRemoveAgentCapsPDU;
    }

    private static AgentXPDU parseResponsePDU(byte[] byArray) throws ParseException {
        AgentXResponsePDU agentXResponsePDU = new AgentXResponsePDU();
        int n = AgentXReader.parseHeader(agentXResponsePDU, byArray);
        agentXResponsePDU.setSysUpTime(AgentXReader.parseInt(n, byArray, agentXResponsePDU.getNetworkByteOrder()));
        agentXResponsePDU.setError(!agentXResponsePDU.getNetworkByteOrder() ? byArray[n + 4] * 256 + byArray[n + 5] : byArray[n + 4] + byArray[n + 5] * 256);
        agentXResponsePDU.setIndex(!agentXResponsePDU.getNetworkByteOrder() ? byArray[n + 6] * 256 + byArray[n + 7] : byArray[n + 6] + byArray[n + 7] * 256);
        if (agentXResponsePDU.getPayloadLength() > 8L) {
            Vector vector = AgentXReader.parseVarBind(n + 8, agentXResponsePDU.getPayloadLength(), byArray, agentXResponsePDU.getNetworkByteOrder());
            agentXResponsePDU.setVarBindList(vector);
        }
        return agentXResponsePDU;
    }

    public static AgentXPDU parsePDU(byte[] byArray) throws ParseException {
        switch (byArray[1]) {
            case 1: {
                return AgentXReader.parseOpenPDU(byArray);
            }
            case 2: {
                return AgentXReader.parseClosePDU(byArray);
            }
            case 3: {
                return AgentXReader.parseRegisterPDU(byArray);
            }
            case 4: {
                return AgentXReader.parseUnregisterPDU(byArray);
            }
            case 5: {
                return AgentXReader.parseGetPDU(byArray);
            }
            case 6: {
                return AgentXReader.parseGetNextPDU(byArray);
            }
            case 7: {
                return AgentXReader.parseGetBulkPDU(byArray);
            }
            case 8: {
                return AgentXReader.parseTestSetPDU(byArray);
            }
            case 9: {
                return AgentXReader.parseCommitSetPDU(byArray);
            }
            case 10: {
                return AgentXReader.parseUndoSetPDU(byArray);
            }
            case 11: {
                return AgentXReader.parseCleanUpSetPDU(byArray);
            }
            case 12: {
                return AgentXReader.parseNotifyPDU(byArray);
            }
            case 13: {
                return AgentXReader.parsePingPDU(byArray);
            }
            case 14: {
                return AgentXReader.parseIndexAllocatePDU(byArray);
            }
            case 15: {
                return AgentXReader.parseIndexDeallocatePDU(byArray);
            }
            case 16: {
                return AgentXReader.parseAddAgentCapsPDU(byArray);
            }
            case 17: {
                return AgentXReader.parseRemoveAgentCapsPDU(byArray);
            }
            case 18: {
                return AgentXReader.parseResponsePDU(byArray);
            }
        }
        throw new ParseException("Unknown PDU-Type", 1);
    }

    public void run() {
        AgentXPDU agentXPDU = null;
        byte[] byArray = new byte[2048];
        int n = 1;
        AgentXDebug.debugMessage("the reader thread is now running");
        try {
            try {
                InputStream inputStream = this.connection.socket.getInputStream();
                while (this.connection.open) {
                    AgentXSession agentXSession;
                    n = inputStream.read(byArray);
                    if (n == -1) {
                        throw new IOException();
                    }
                    try {
                        agentXPDU = AgentXReader.parsePDU(byArray);
                        AgentXDebug.debugMessage("PDU received");
                        AgentXDebug.debugPdu(agentXPDU);
                    }
                    catch (ParseException parseException) {
                        AgentXDebug.debugMessage("reader received an unparseable PDU: " + parseException);
                    }
                    if (agentXPDU instanceof AgentXResponsePDU) {
                        agentXSession = this.connection.getSession(0L);
                        if (agentXSession != null) {
                            agentXSession.setSessionID(agentXPDU.getSessionID());
                        }
                        AgentXConnection agentXConnection = this.connection;
                        synchronized (agentXConnection) {
                            this.connection.setReceivedPDU(agentXPDU);
                            this.connection.notify();
                            continue;
                        }
                    }
                    agentXSession = this.connection.getSession(agentXPDU.getSessionID());
                    if (agentXPDU instanceof AgentXGetPDU) {
                        AgentXDebug.debugMessage("processing Get PDU");
                        agentXSession.handleGetPDU((AgentXGetPDU)agentXPDU);
                        continue;
                    }
                    if (agentXPDU instanceof AgentXGetNextPDU) {
                        AgentXDebug.debugMessage("processing GetNext PDU");
                        agentXSession.handleGetNextPDU((AgentXGetNextPDU)agentXPDU);
                        continue;
                    }
                    if (agentXPDU instanceof AgentXTestSetPDU || agentXPDU instanceof AgentXUndoSetPDU || agentXPDU instanceof AgentXCommitSetPDU || agentXPDU instanceof AgentXCleanUpSetPDU) {
                        AgentXDebug.debugMessage("processing setRequest");
                        agentXSession.handleSetRequest(agentXPDU);
                        continue;
                    }
                    AgentXDebug.debugMessage("reader cannot handle PDU");
                }
            }
            catch (IOException iOException) {
                AgentXDebug.debugMessage("reader died: " + iOException);
                Object var9_11 = null;
                if (this.signaller != null) {
                    if (this.connection.open) {
                        this.signaller.signal(1);
                    } else {
                        this.signaller.signal(0);
                    }
                }
            }
            Object var9_10 = null;
            if (this.signaller != null) {
                if (this.connection.open) {
                    this.signaller.signal(1);
                } else {
                    this.signaller.signal(0);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (this.signaller != null) {
                if (this.connection.open) {
                    this.signaller.signal(1);
                } else {
                    this.signaller.signal(0);
                }
            }
            throw throwable;
        }
    }
}

