/*
 * Decompiled with CFR 0.152.
 */
package jax;

import jax.AgentXOID;
import jax.AgentXPDU;

public class AgentXRegisterPDU
extends AgentXPDU {
    private long[] empty = new long[0];
    private AgentXOID rSubtree = new AgentXOID(this.empty);
    private int rRangeSubID = 0;
    private long rUpperBound;
    private long rPriority = 127L;
    private long rTimeout;

    public AgentXRegisterPDU() {
        this.setType(3);
        this.setPayloadLength(8L);
    }

    private byte[] getRegisterBytes() {
        byte[] byArray = new byte[]{(byte)this.rTimeout, (byte)this.rPriority, (byte)this.rRangeSubID, 0};
        byArray = this.joinBytes(byArray, this.getOIDBytes(this.rSubtree));
        if (this.rRangeSubID > 0) {
            byArray = this.joinBytes(byArray, this.getIntBytes(this.rUpperBound));
        }
        return byArray;
    }

    private String toRegisterString() {
        return "RegisterPDU-----------------------------------------------\nTimeout:" + this.rTimeout + " Priority:" + this.rPriority + " \n" + "OID: " + this.rSubtree + "\n" + (this.rRangeSubID > 0 ? "RangeSubID:" + this.rRangeSubID + " UpperBound:" + this.rUpperBound + "\n" : "") + "-----------------------------------------------RegisterPDU\n";
    }

    public byte[] getBytes() {
        byte[] byArray = this.joinBytes(this.getHeaderBytes(), this.getRegisterBytes());
        return byArray;
    }

    public String toString() {
        return this.toHeaderString() + this.toRegisterString();
    }

    public void setRangeSubID(int n) {
        if (this.updatePayloadLength) {
            if (n > 0 && this.rRangeSubID == 0) {
                this.setPayloadLength(this.getPayloadLength() + 4L);
            }
            if (n == 0 && this.rRangeSubID > 0) {
                this.setPayloadLength(this.getPayloadLength() - 4L);
            }
        }
        this.rRangeSubID = n;
    }

    public int getRangeSubid() {
        return this.rRangeSubID;
    }

    public void setPriority(int n) throws ClassCastException {
        if (n > 256) {
            throw new ClassCastException();
        }
        this.rPriority = n;
    }

    public long getPriority() {
        return this.rPriority;
    }

    public void setUpperBound(long l) {
        this.rUpperBound = l;
    }

    public long getUpperBound() {
        return this.rUpperBound;
    }

    public void setSubtree(AgentXOID agentXOID) {
        if (this.updatePayloadLength) {
            this.setPayloadLength(this.getPayloadLength() + (long)(agentXOID.getLength() * 4) - (long)(this.rSubtree.getLength() * 4));
        }
        this.rSubtree = agentXOID;
    }

    public AgentXOID getSubtree() {
        return this.rSubtree;
    }

    public void setTimeout(int n) throws ClassCastException {
        if (n > 256) {
            throw new ClassCastException();
        }
        this.rTimeout = n;
    }

    public long getTimeout() {
        return this.rTimeout;
    }
}

