/*
 * Decompiled with CFR 0.152.
 */
package jax;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jax.AgentXCleanUpSetPDU;
import jax.AgentXCommitSetPDU;
import jax.AgentXConnection;
import jax.AgentXDebug;
import jax.AgentXGetNextPDU;
import jax.AgentXGetPDU;
import jax.AgentXGroup;
import jax.AgentXNotification;
import jax.AgentXNotifyPDU;
import jax.AgentXOID;
import jax.AgentXPDU;
import jax.AgentXRegisterPDU;
import jax.AgentXRegistration;
import jax.AgentXResponsePDU;
import jax.AgentXSetPhase;
import jax.AgentXTestSetPDU;
import jax.AgentXUndoSetPDU;
import jax.AgentXUnregisterPDU;
import jax.AgentXVarBind;

public class AgentXSession {
    private AgentXConnection connection;
    private AgentXOID oid = new AgentXOID();
    private String description = "";
    private short timeout = 0;
    private long sessionID = 0L;
    public Vector groups = new Vector();
    Vector testSetPDUs = new Vector();
    public static final short REASON_OTHER = 1;
    public static final short REASON_PARSERERROR = 2;
    public static final short REASON_PROTOCOLERROR = 3;
    public static final short REASON_TIMEOUTS = 4;
    public static final short REASON_SHUTDOWN = 5;
    public static final short REASON_BYMANAGER = 6;

    protected void setConnection(AgentXConnection agentXConnection) {
        this.connection = agentXConnection;
    }

    protected void setSessionID(long l) {
        this.sessionID = l;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public AgentXOID getOID() {
        return this.oid;
    }

    public void setOID(AgentXOID agentXOID) {
        this.oid = agentXOID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public short getTimeout() {
        return this.timeout;
    }

    public void setTimeout(short s) {
        this.timeout = s;
    }

    public void close(short s) throws IOException, InterruptedException {
        this.connection.closeSession(this, s);
    }

    public void register(AgentXRegistration agentXRegistration) throws IOException, InterruptedException {
        AgentXRegisterPDU agentXRegisterPDU = new AgentXRegisterPDU();
        agentXRegisterPDU.setSubtree(agentXRegistration.getOID());
        agentXRegisterPDU.setPriority(agentXRegistration.getPriority());
        agentXRegisterPDU.setTimeout(agentXRegistration.getTimeout());
        agentXRegisterPDU.setRangeSubID(agentXRegistration.getRangeSubID());
        agentXRegisterPDU.setUpperBound(agentXRegistration.getUpperBound());
        AgentXConnection agentXConnection = this.connection;
        synchronized (agentXConnection) {
            this.send(agentXRegisterPDU);
            AgentXDebug.debugMessage("waiting for register response");
            try {
                AgentXConnection agentXConnection2 = this.connection;
                synchronized (agentXConnection2) {
                    this.connection.wait();
                    AgentXPDU agentXPDU = this.connection.getReceivedPDU();
                    if (!(agentXPDU instanceof AgentXResponsePDU) || agentXPDU.getSessionID() != this.getSessionID()) {
                        throw new IOException("unexpected PDU or session id\n");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                AgentXDebug.debugMessage("interrupted wait: " + interruptedException);
                throw interruptedException;
            }
        }
        AgentXDebug.debugMessage("got response, subtree registered");
    }

    public void unregister(AgentXRegistration agentXRegistration) throws InterruptedException, IOException {
        AgentXUnregisterPDU agentXUnregisterPDU = new AgentXUnregisterPDU();
        agentXUnregisterPDU.setSubtree(agentXRegistration.getOID());
        agentXUnregisterPDU.setPriority(agentXRegistration.getPriority());
        agentXUnregisterPDU.setRangeSubID(agentXRegistration.getRangeSubID());
        agentXUnregisterPDU.setUpperBound(agentXRegistration.getUpperBound());
        AgentXConnection agentXConnection = this.connection;
        synchronized (agentXConnection) {
            this.send(agentXUnregisterPDU);
            AgentXDebug.debugMessage("waiting for unregister response");
            try {
                AgentXConnection agentXConnection2 = this.connection;
                synchronized (agentXConnection2) {
                    this.connection.wait();
                    AgentXPDU agentXPDU = this.connection.getReceivedPDU();
                    if (!(agentXPDU instanceof AgentXResponsePDU) || agentXPDU.getSessionID() != this.getSessionID()) {
                        throw new IOException("unexpected PDU or session id\n");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                AgentXDebug.debugMessage("interrupted wait: " + interruptedException);
                throw interruptedException;
            }
        }
        AgentXDebug.debugMessage("got response, subtree unregistered");
    }

    public void addGroup(AgentXGroup agentXGroup) {
        AgentXOID agentXOID = agentXGroup.getOID();
        int n = 0;
        while (n < this.groups.size() && agentXOID.compareTo(((AgentXGroup)this.groups.elementAt(n)).getOID()) >= 0) {
            ++n;
        }
        try {
            this.groups.insertElementAt(agentXGroup, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeGroup(AgentXGroup agentXGroup) {
        AgentXOID agentXOID = agentXGroup.getOID();
        int n = 0;
        while (n < this.groups.size() && agentXOID.compareTo(((AgentXGroup)this.groups.elementAt(n)).getOID()) >= 0) {
            ++n;
        }
        if (n < this.groups.size()) {
            try {
                this.groups.removeElementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        String string = new String();
        string = "Session \"" + this.description + "\" (" + this.oid.toString() + ") with " + "timeout = " + this.timeout;
        return string;
    }

    public void send(AgentXPDU agentXPDU) throws IOException {
        if (agentXPDU.getSessionID() == 0L) {
            agentXPDU.setSessionID(this.sessionID);
        }
        this.connection.send(agentXPDU);
    }

    public void notify(AgentXNotification agentXNotification) throws IOException {
        AgentXNotifyPDU agentXNotifyPDU = new AgentXNotifyPDU();
        agentXNotifyPDU.setVarBindList(agentXNotification.getVarBindList());
        this.send(agentXNotifyPDU);
    }

    public void handleGetPDU(AgentXGetPDU agentXGetPDU) throws IOException {
        AgentXVarBind agentXVarBind = null;
        Vector<AgentXVarBind> vector = new Vector<AgentXVarBind>();
        Enumeration enumeration = agentXGetPDU.elements();
        AgentXGroup agentXGroup = null;
        while (enumeration.hasMoreElements()) {
            AgentXOID agentXOID = (AgentXOID)enumeration.nextElement();
            int n = 0;
            while (n < this.groups.size()) {
                agentXGroup = (AgentXGroup)this.groups.elementAt(n);
                int n2 = agentXOID.compareTo(agentXGroup.getOID());
                if (n2 == 0 || n2 > agentXGroup.getOID().getLength()) break;
                ++n;
            }
            agentXVarBind = n < this.groups.size() ? agentXGroup.getElement(agentXOID) : new AgentXVarBind(agentXOID, 128);
            vector.addElement(agentXVarBind);
        }
        AgentXResponsePDU agentXResponsePDU = new AgentXResponsePDU();
        agentXResponsePDU.setTransactionID(agentXGetPDU.getTransactionID());
        agentXResponsePDU.setPacketID(agentXGetPDU.getPacketID());
        agentXResponsePDU.setVarBindList(vector);
        this.send(agentXResponsePDU);
    }

    public void handleGetNextPDU(AgentXGetNextPDU agentXGetNextPDU) throws IOException {
        AgentXVarBind agentXVarBind = null;
        Vector<AgentXVarBind> vector = new Vector<AgentXVarBind>();
        Enumeration enumeration = agentXGetNextPDU.elements();
        AgentXGroup agentXGroup = null;
        while (enumeration.hasMoreElements()) {
            AgentXOID agentXOID = (AgentXOID)enumeration.nextElement();
            AgentXOID agentXOID2 = (AgentXOID)enumeration.nextElement();
            agentXVarBind = null;
            int n = 0;
            while (n < this.groups.size()) {
                int n2;
                agentXGroup = (AgentXGroup)this.groups.elementAt(n);
                if (agentXOID == null) {
                    agentXOID = agentXGroup.getOID();
                }
                if ((n2 = agentXOID.compareTo(agentXGroup.getOID())) <= 0 || n2 > agentXGroup.getOID().getLength()) {
                    agentXVarBind = agentXGroup.getNextElement(agentXOID);
                    if (agentXVarBind.getType() != 130 && (agentXOID2.compareTo(agentXOID) > 0 || agentXOID2.compareTo(new AgentXOID()) == 0)) break;
                    agentXOID = null;
                }
                ++n;
            }
            if (agentXVarBind == null) {
                agentXVarBind = new AgentXVarBind(agentXOID, 130);
            }
            vector.addElement(agentXVarBind);
        }
        AgentXResponsePDU agentXResponsePDU = new AgentXResponsePDU();
        agentXResponsePDU.setTransactionID(agentXGetNextPDU.getTransactionID());
        agentXResponsePDU.setPacketID(agentXGetNextPDU.getPacketID());
        agentXResponsePDU.setVarBindList(vector);
        this.send(agentXResponsePDU);
    }

    public void handleSetRequest(AgentXPDU agentXPDU) throws IOException {
        Object object;
        Object object2;
        Enumeration enumeration = null;
        AgentXGroup agentXGroup = null;
        AgentXTestSetPDU agentXTestSetPDU = null;
        int n = 0;
        int n2 = 0;
        AgentXResponsePDU agentXResponsePDU = new AgentXResponsePDU();
        agentXResponsePDU.setTransactionID(agentXPDU.getTransactionID());
        agentXResponsePDU.setPacketID(agentXPDU.getPacketID());
        if (agentXPDU instanceof AgentXTestSetPDU) {
            this.testSetPDUs.addElement(agentXPDU);
            agentXTestSetPDU = (AgentXTestSetPDU)agentXPDU;
        } else {
            object2 = this.testSetPDUs.elements();
            while (agentXTestSetPDU == null && object2.hasMoreElements()) {
                object = (AgentXTestSetPDU)object2.nextElement();
                if (agentXPDU.getTransactionID() != ((AgentXPDU)object).getTransactionID()) continue;
                agentXTestSetPDU = object;
            }
        }
        if (agentXTestSetPDU == null) {
            agentXResponsePDU.setError(268);
            this.send(agentXResponsePDU);
        } else {
            enumeration = agentXTestSetPDU.getVarBindList().elements();
            while (enumeration.hasMoreElements() && agentXResponsePDU.getError() == 0) {
                object2 = (AgentXVarBind)enumeration.nextElement();
                ++n2;
                object = ((AgentXVarBind)object2).getOID();
                n = 0;
                while (n < this.groups.size()) {
                    agentXGroup = (AgentXGroup)this.groups.elementAt(n);
                    int n3 = ((AgentXOID)object).compareTo(agentXGroup.getOID());
                    if (n3 == 0 || n3 > agentXGroup.getOID().getLength()) break;
                    ++n;
                }
                if (n >= this.groups.size()) {
                    agentXResponsePDU.setError(18);
                    continue;
                }
                AgentXSetPhase agentXSetPhase = new AgentXSetPhase();
                if (agentXPDU instanceof AgentXTestSetPDU) {
                    AgentXDebug.debugMessage("test set on varbind:\n" + object2);
                    agentXSetPhase.setPhase(1);
                    agentXResponsePDU.setError(agentXGroup.setElement(agentXSetPhase, (AgentXVarBind)object2));
                    continue;
                }
                if (agentXPDU instanceof AgentXUndoSetPDU) {
                    AgentXDebug.debugMessage("undo varbind:\n" + object2);
                    agentXSetPhase.setPhase(3);
                    agentXResponsePDU.setError(agentXGroup.setElement(agentXSetPhase, (AgentXVarBind)object2));
                    continue;
                }
                if (agentXPDU instanceof AgentXCommitSetPDU) {
                    AgentXDebug.debugMessage("commiting varbind:\n" + object2);
                    agentXSetPhase.setPhase(2);
                    agentXResponsePDU.setError(agentXGroup.setElement(agentXSetPhase, (AgentXVarBind)object2));
                    continue;
                }
                if (!(agentXPDU instanceof AgentXCleanUpSetPDU)) continue;
                AgentXDebug.debugMessage("clean up for varbind:\n" + object2);
                agentXSetPhase.setPhase(4);
                agentXGroup.setElement(agentXSetPhase, (AgentXVarBind)object2);
                if (enumeration.hasMoreElements()) continue;
                this.testSetPDUs.removeElement(agentXTestSetPDU);
            }
            if (agentXResponsePDU.getError() != 0) {
                AgentXDebug.debugMessage("-> operation failed");
                agentXResponsePDU.setIndex(n2);
            } else {
                AgentXDebug.debugMessage("-> success");
            }
            if (!(agentXPDU instanceof AgentXCleanUpSetPDU)) {
                this.send(agentXResponsePDU);
            }
        }
    }
}

