/*
 * Decompiled with CFR 0.152.
 */
package jax;

import java.util.Enumeration;
import java.util.Vector;
import jax.AgentXEntry;
import jax.AgentXGroup;
import jax.AgentXOID;
import jax.AgentXSetPhase;
import jax.AgentXVarBind;

public abstract class AgentXTable
implements AgentXGroup {
    public Vector rows = new Vector();
    public Vector columns = new Vector();
    public AgentXOID oid;
    protected boolean registered_per_row;

    public AgentXTable() {
        this.registered_per_row = false;
    }

    public AgentXTable(boolean bl) {
        this.registered_per_row = bl;
    }

    public AgentXOID getOID() {
        return this.oid;
    }

    public AgentXOID getSuffix(AgentXOID agentXOID) {
        return agentXOID.getSuffix(this.oid);
    }

    public Enumeration elements() {
        return this.rows.elements();
    }

    public int size() {
        return this.rows.size();
    }

    public void addEntry(AgentXEntry agentXEntry) {
        AgentXOID agentXOID = agentXEntry.getInstance();
        int n = 0;
        while (n < this.rows.size() && agentXOID.compareTo(((AgentXEntry)this.rows.elementAt(n)).getInstance()) >= 0) {
            ++n;
        }
        try {
            this.rows.insertElementAt(agentXEntry, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeEntry(AgentXEntry agentXEntry) {
        AgentXOID agentXOID = agentXEntry.getInstance();
        int n = 0;
        while (n < this.rows.size() && agentXOID.compareTo(((AgentXEntry)this.rows.elementAt(n)).getInstance()) != 0) {
            ++n;
        }
        if (n < this.rows.size()) {
            try {
                this.rows.removeElementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public abstract AgentXVarBind getVarBind(AgentXEntry var1, long var2);

    public abstract int setEntry(AgentXSetPhase var1, AgentXEntry var2, long var3, AgentXVarBind var5);

    AgentXEntry findElement(AgentXOID agentXOID) {
        AgentXOID agentXOID2 = this.getSuffix(agentXOID);
        if (agentXOID2.getLength() < 2) {
            return null;
        }
        AgentXOID agentXOID3 = agentXOID2.getInstance();
        int n = 0;
        while (n < this.rows.size()) {
            if (agentXOID3.compareTo(((AgentXEntry)this.rows.elementAt(n)).getInstance()) <= 0) break;
            ++n;
        }
        if (n >= this.rows.size() || agentXOID3.compareTo(((AgentXEntry)this.rows.elementAt(n)).getInstance()) != 0) {
            return null;
        }
        return (AgentXEntry)this.rows.elementAt(n);
    }

    public AgentXVarBind getElement(AgentXOID agentXOID) {
        AgentXOID agentXOID2 = this.getSuffix(agentXOID);
        long l = agentXOID2.getColumn();
        AgentXEntry agentXEntry = this.findElement(agentXOID);
        AgentXVarBind agentXVarBind = agentXEntry != null ? this.getVarBind(agentXEntry, l) : new AgentXVarBind(agentXOID, 128);
        return agentXVarBind;
    }

    public int setElement(AgentXSetPhase agentXSetPhase, AgentXVarBind agentXVarBind) {
        AgentXOID agentXOID = agentXVarBind.getOID();
        AgentXOID agentXOID2 = this.getSuffix(agentXOID);
        long l = agentXOID2.getColumn();
        AgentXEntry agentXEntry = this.findElement(agentXVarBind.getOID());
        if (agentXEntry != null) {
            return this.setEntry(agentXSetPhase, agentXEntry, l, agentXVarBind);
        }
        return 18;
    }

    public AgentXVarBind getNextElement(AgentXOID agentXOID) {
        AgentXOID agentXOID2;
        AgentXOID agentXOID3 = this.getSuffix(agentXOID);
        long l = agentXOID3.getLength() >= 1 ? agentXOID3.getColumn() : 1L;
        int n = 0;
        while (n < this.columns.size()) {
            if ((Long)this.columns.elementAt(n) >= l) break;
            ++n;
        }
        if (n == this.columns.size()) {
            return new AgentXVarBind(agentXOID, 130);
        }
        if ((Long)this.columns.elementAt(n) > l) {
            l = (Long)this.columns.elementAt(n);
            agentXOID2 = new AgentXOID(new long[0]);
        } else {
            agentXOID2 = agentXOID3.getInstance();
        }
        n = 0;
        while (n < this.rows.size()) {
            if (agentXOID2.compareTo(((AgentXEntry)this.rows.elementAt(n)).getInstance()) < 0) break;
            ++n;
        }
        if (n == this.rows.size()) {
            if (!this.registered_per_row) {
                ++l;
                n = 0;
                while (n < this.columns.size()) {
                    if ((Long)this.columns.elementAt(n) >= l) break;
                    ++n;
                }
                if (n == this.columns.size()) {
                    return new AgentXVarBind(agentXOID, 130);
                }
                AgentXOID agentXOID4 = new AgentXOID(this.getOID(), (Long)this.columns.elementAt(n));
                return this.getNextElement(agentXOID4);
            }
            return new AgentXVarBind(agentXOID, 130);
        }
        AgentXVarBind agentXVarBind = this.getVarBind((AgentXEntry)this.rows.elementAt(n), l);
        if (agentXVarBind == null) {
            agentXVarBind = new AgentXVarBind(agentXOID, 130);
        }
        return agentXVarBind;
    }
}

