/*
 * Decompiled with CFR 0.152.
 */
package jax;

import jax.AgentXOID;

public class AgentXVarBind {
    private AgentXOID oid;
    private int type;
    private long value_long;
    private AgentXOID value_oid;
    private byte[] value_bytes;
    public static final int INTEGER = 2;
    public static final int OCTETSTRING = 4;
    public static final int NULL = 5;
    public static final int OBJECTIDENTIFIER = 6;
    public static final int IPADDRESS = 64;
    public static final int COUNTER32 = 65;
    public static final int GAUGE32 = 66;
    public static final int TIMETICKS = 67;
    public static final int OPAQUE = 68;
    public static final int COUNTER64 = 70;
    public static final int NOSUCHOBJECT = 128;
    public static final int NOSUCHINSTANCE = 129;
    public static final int ENDOFMIBVIEW = 130;
    public static final long[] zeroDotZero = new long[]{0L, 0L};

    public AgentXVarBind() {
        this.type = 5;
        this.oid = new AgentXOID(zeroDotZero);
    }

    public AgentXVarBind(AgentXOID agentXOID, int n) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 5: {
                break;
            }
        }
    }

    public AgentXVarBind(AgentXOID agentXOID, int n, int n2) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                this.value_long = n2;
                break;
            }
        }
    }

    public AgentXVarBind(AgentXOID agentXOID, int n, AgentXOID agentXOID2) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 6: {
                this.value_oid = agentXOID2;
                break;
            }
        }
    }

    public AgentXVarBind(AgentXOID agentXOID, int n, long l) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                this.value_long = l;
                break;
            }
        }
    }

    public AgentXVarBind(AgentXOID agentXOID, int n, String string) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 4: 
            case 68: {
                char[] cArray = string.toCharArray();
                this.value_bytes = new byte[cArray.length];
                int n2 = 0;
                while (n2 < cArray.length) {
                    this.value_bytes[n2] = (byte)cArray[n2];
                    ++n2;
                }
                break;
            }
        }
    }

    public AgentXVarBind(AgentXOID agentXOID, int n, byte[] byArray) {
        this.oid = agentXOID;
        this.type = n;
        switch (n) {
            case 4: 
            case 64: 
            case 68: {
                this.value_bytes = byArray;
                break;
            }
        }
    }

    public AgentXOID getOID() {
        return this.oid;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String string = new String();
        string = this.oid.toString() + " = ";
        string = string + this.getValueString() + " (" + this.getTypeString() + ")";
        return string;
    }

    public String getValueString() {
        String string;
        switch (this.type) {
            case 5: {
                string = "<NULL>";
                break;
            }
            case 2: {
                string = String.valueOf(this.value_long);
                break;
            }
            case 6: {
                string = this.value_oid.toString();
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                string = String.valueOf(this.value_long);
                break;
            }
            case 4: 
            case 68: {
                string = "";
                int n = 0;
                while (n < this.value_bytes.length) {
                    if (this.value_bytes[n] < 32 && this.value_bytes[n] >= 0) break;
                    if (n > 0) {
                        string = string + ":";
                    }
                    string = string + this.value_bytes[n];
                    ++n;
                }
                if (n != this.value_bytes.length) break;
                string = "\"" + new String(this.value_bytes) + "\"";
                break;
            }
            case 64: {
                string = "";
                int n = 0;
                while (n < this.value_bytes.length) {
                    if (n > 0) {
                        string = string + ".";
                    }
                    int n2 = this.value_bytes[n];
                    string = string + (n2 >= 0 ? n2 : 256 + n2);
                    ++n;
                }
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                string = "<no value>";
                break;
            }
            default: {
                string = "<unknown type " + this.type + ">";
            }
        }
        return string;
    }

    public void setOID(AgentXOID agentXOID) {
        this.oid = agentXOID;
    }

    public String getTypeString() {
        switch (this.type) {
            case 2: {
                return "Integer";
            }
            case 4: {
                return "Octet String";
            }
            case 5: {
                return "Null";
            }
            case 6: {
                return "Object Identifier";
            }
            case 64: {
                return "IpAddress";
            }
            case 65: {
                return "Counter32";
            }
            case 66: {
                return "Gauge32";
            }
            case 67: {
                return "TimeTicks";
            }
            case 68: {
                return "Opaque";
            }
            case 70: {
                return "Counter64";
            }
            case 128: {
                return "noSuchObject";
            }
            case 129: {
                return "noSuchInstance";
            }
            case 130: {
                return "endOfMibView";
            }
        }
        return "<unknown type " + this.type + ">";
    }

    public int intValue() {
        int n = 0;
        switch (this.type) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                n = (int)this.value_long;
                break;
            }
        }
        return n;
    }

    public AgentXOID AgentXOIDValue() {
        AgentXOID agentXOID = null;
        switch (this.type) {
            case 6: {
                agentXOID = this.value_oid;
                break;
            }
        }
        return agentXOID;
    }

    public long longValue() {
        long l = 0L;
        switch (this.type) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                l = this.value_long;
                break;
            }
        }
        return l;
    }

    public String stringValue() {
        String string = null;
        switch (this.type) {
            case 4: 
            case 68: {
                string = new String(this.value_bytes);
                break;
            }
        }
        return string;
    }

    public byte[] bytesValue() {
        byte[] byArray = null;
        switch (this.type) {
            case 4: 
            case 64: 
            case 68: {
                byArray = this.value_bytes;
                break;
            }
        }
        return byArray;
    }

    public void setInt(long l) {
        this.value_long = l;
    }

    public void setLong(long l) {
        this.value_long = l;
    }

    public void setBytes(byte[] byArray) {
        this.value_bytes = byArray;
    }

    public void setAgentXOID(AgentXOID agentXOID) {
        this.value_oid = agentXOID;
    }

    public int getValueType() {
        return this.type;
    }

    public void setValueType(int n) {
        this.type = n;
    }
}

