/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Trace;

abstract class BaseMemoryNode
extends Node {
    protected Node nLeft;
    protected Node nRight;
    protected Node nParent;

    BaseMemoryNode() {
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    Node getLeft() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return this.nLeft;
    }

    void setLeft(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        this.nLeft = node;
    }

    Node getRight() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return this.nRight;
    }

    void setRight(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        this.nRight = node;
    }

    Node getParent() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return this.nParent;
    }

    boolean isRoot() {
        return this.nParent == null;
    }

    void setParent(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        this.nParent = node;
    }

    void setBalance(int n) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        this.iBalance = n;
    }

    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        Node node = this.getParent();
        Trace.doAssert(node != null);
        return this.equals(node.getLeft());
    }

    boolean equals(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return node == this;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
    }
}

